/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.autoconfigure;

import cn.herodotus.engine.rest.condition.annotation.ConditionalOnUseHttp2ClientAsRestClient;
import cn.herodotus.engine.rest.condition.annotation.ConditionalOnUseHttpClient5AsRestClient;
import cn.herodotus.engine.rest.condition.annotation.ConditionalOnUseSimpleClientAsRestClient;
import feign.hc5.ApacheHttp5Client;
import feign.http2client.Http2Client;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.net.http.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={FeignAutoConfiguration.class})
public class RestTemplateAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Module [Rest Template] Auto Configure.");
    }

    @Bean
    @ConditionalOnClass(value={Http2Client.class, HttpClient.class})
    @ConditionalOnMissingBean(value={HttpClient.class})
    @ConditionalOnUseHttp2ClientAsRestClient
    public ClientHttpRequestFactory jdkClientHttpRequestFactory(HttpClient httpClient) {
        JdkClientHttpRequestFactory factory = new JdkClientHttpRequestFactory(httpClient);
        log.trace("[Herodotus] |- Bean [Jdk Client Http Request Factory] Auto Configure.");
        return factory;
    }

    @Bean
    @ConditionalOnClass(value={ApacheHttp5Client.class})
    @ConditionalOnMissingBean(value={CloseableHttpClient.class})
    @ConditionalOnUseHttpClient5AsRestClient
    public ClientHttpRequestFactory httpComponentsClientHttpRequestFactory(CloseableHttpClient closeableHttpClient) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((org.apache.hc.client5.http.classic.HttpClient)closeableHttpClient);
        log.trace("[Herodotus] |- Bean [Http Components Http Request Factory] Auto Configure.");
        return factory;
    }

    @Bean
    @ConditionalOnUseSimpleClientAsRestClient
    @ConditionalOnMissingBean
    public ClientHttpRequestFactory SimpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        log.trace("[Herodotus] |- Bean [Simple Client Http Request Factory] Auto Configure.");
        return factory;
    }

    @Bean
    @LoadBalanced
    public RestTemplate getRestTemplate(ClientHttpRequestFactory clientHttpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(clientHttpRequestFactory);
        ResponseErrorHandler responseErrorHandler = new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse response) throws IOException {
                return true;
            }

            public void handleError(ClientHttpResponse response) throws IOException {
            }
        };
        restTemplate.setErrorHandler(responseErrorHandler);
        log.trace("[Herodotus] |- Bean [Rest Template] Auto Configure.");
        return restTemplate;
    }
}

