/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.autoconfigure.protect;

import cn.herodotus.engine.rest.autoconfigure.protect.jackson2.Jackson2XssObjectMapperBuilderCustomizer;
import cn.herodotus.engine.rest.protect.configuration.HttpCryptoConfiguration;
import cn.herodotus.engine.rest.protect.configuration.SecureConfiguration;
import cn.herodotus.engine.rest.protect.configuration.TenantConfiguration;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@Import(value={HttpCryptoConfiguration.class, SecureConfiguration.class, TenantConfiguration.class})
public class RestProtectAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestProtectAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Rest Protect] Auto Configure.");
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssObjectMapperBuilderCustomizer() {
        Jackson2XssObjectMapperBuilderCustomizer customizer = new Jackson2XssObjectMapperBuilderCustomizer();
        log.trace("[Herodotus] |- Strategy [Jackson2 Xss ObjectMapper Builder Customizer] Auto Configure.");
        return customizer;
    }
}

