/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.configuration;

import cn.herodotus.engine.rest.crypto.configuration.CryptoConfiguration;
import cn.herodotus.engine.rest.crypto.enhance.DecryptRequestParamMapResolver;
import cn.herodotus.engine.rest.crypto.enhance.DecryptRequestParamResolver;
import cn.herodotus.engine.rest.secure.configuration.SecureConfiguration;
import cn.herodotus.engine.rest.secure.interceptor.AccessLimitedInterceptor;
import cn.herodotus.engine.rest.secure.interceptor.IdempotentInterceptor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration(proxyBeanMethods=false)
@Import(value={CryptoConfiguration.class, SecureConfiguration.class})
public class WebMvcConfiguration
extends WebMvcConfigurationSupport {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfiguration.class);
    @Autowired
    private IdempotentInterceptor idempotentInterceptor;
    @Autowired
    private AccessLimitedInterceptor accessLimitedInterceptor;
    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    @Autowired
    private DecryptRequestParamResolver decryptRequestParamResolver;
    @Autowired
    private DecryptRequestParamMapResolver decryptRequestParamMapResolver;

    @PostConstruct
    public void postConstruct() {
        this.postArgumentMethodHandlers();
        log.info("[Herodotus] |- Core [Web Mvc Configurer] Auto Configure.");
    }

    private void postArgumentMethodHandlers() {
        List unmodifiableList = this.requestMappingHandlerAdapter.getArgumentResolvers();
        ArrayList list = Lists.newArrayList();
        for (HandlerMethodArgumentResolver methodArgumentResolver : unmodifiableList) {
            if (methodArgumentResolver instanceof RequestParamMapMethodArgumentResolver) {
                this.decryptRequestParamMapResolver.setRequestParamMapMethodArgumentResolver((RequestParamMapMethodArgumentResolver)methodArgumentResolver);
                list.add(this.decryptRequestParamMapResolver);
            }
            if (methodArgumentResolver instanceof RequestParamMethodArgumentResolver) {
                this.decryptRequestParamResolver.setRequestParamMethodArgumentResolver((RequestParamMethodArgumentResolver)methodArgumentResolver);
                list.add(this.decryptRequestParamResolver);
            }
            list.add(methodArgumentResolver);
        }
        log.debug("[Herodotus] |- Custom HandlerMethodArgumentResolver Auto Configure.");
        this.requestMappingHandlerAdapter.setArgumentResolvers((List)list);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.accessLimitedInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.idempotentInterceptor);
        super.addInterceptors(registry);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }
}

