/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.configuration;

import cn.herodotus.engine.protect.web.crypto.enhance.DecryptRequestParamMapResolver;
import cn.herodotus.engine.protect.web.crypto.enhance.DecryptRequestParamResolver;
import cn.herodotus.engine.rest.configuration.RestWebConfiguration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration(proxyBeanMethods=false)
public class RestCryptoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestWebConfiguration.class);
    private final RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private final DecryptRequestParamResolver decryptRequestParamResolver;
    private final DecryptRequestParamMapResolver decryptRequestParamMapResolver;

    @Autowired
    public RestCryptoConfiguration(RequestMappingHandlerAdapter requestMappingHandlerAdapter, DecryptRequestParamResolver decryptRequestParamResolver, DecryptRequestParamMapResolver decryptRequestParamMapResolver) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
        this.decryptRequestParamResolver = decryptRequestParamResolver;
        this.decryptRequestParamMapResolver = decryptRequestParamMapResolver;
    }

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- SDK [Rest Crypto] Auto Configure.");
        List unmodifiableList = this.requestMappingHandlerAdapter.getArgumentResolvers();
        ArrayList list = Lists.newArrayList();
        for (HandlerMethodArgumentResolver methodArgumentResolver : unmodifiableList) {
            if (methodArgumentResolver instanceof RequestParamMapMethodArgumentResolver) {
                this.decryptRequestParamMapResolver.setRequestParamMapMethodArgumentResolver((RequestParamMapMethodArgumentResolver)methodArgumentResolver);
                list.add(this.decryptRequestParamMapResolver);
            }
            if (methodArgumentResolver instanceof RequestParamMethodArgumentResolver) {
                this.decryptRequestParamResolver.setRequestParamMethodArgumentResolver((RequestParamMethodArgumentResolver)methodArgumentResolver);
                list.add(this.decryptRequestParamResolver);
            }
            list.add(methodArgumentResolver);
        }
        log.debug("[Herodotus] |- Rest Crypto HandlerMethodArgumentResolver Auto Configure.");
        this.requestMappingHandlerAdapter.setArgumentResolvers((List)list);
    }
}

