/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.dto;

import cn.herodotus.engine.core.definition.domain.AbstractDto;
import cn.herodotus.engine.logic.upms.entity.hr.SysDepartment;
import cn.herodotus.engine.logic.upms.entity.hr.SysEmployee;
import cn.herodotus.engine.logic.upms.entity.hr.SysOwnership;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@Schema(description="\u589e\u52a0\u4eba\u5458\u5f52\u5c5e\u53c2\u6570BO\u5bf9\u8c61")
public class AllocatableDeploy
extends AbstractDto {
    @NotNull(message="\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u5355\u4f4dID")
    private @NotNull(message="\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a") String organizationId;
    @NotNull(message="\u90e8\u95e8ID\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u90e8\u95e8ID")
    private @NotNull(message="\u90e8\u95e8ID\u4e0d\u80fd\u4e3a\u7a7a") String departmentId;
    @Schema(description="\u914d\u7f6e\u7684\u4eba\u5458\u5217\u8868")
    private List<SysEmployee> employees;

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public List<SysEmployee> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<SysEmployee> employees) {
        this.employees = employees;
    }

    public List<SysEmployee> getAllocatable() {
        if (CollectionUtils.isNotEmpty(this.employees)) {
            return this.employees.stream().peek(employee -> {
                SysDepartment sysDepartment = new SysDepartment();
                sysDepartment.setDepartmentId(this.departmentId);
                HashSet<SysDepartment> sysDepartments = employee.getDepartments();
                if (CollectionUtils.isEmpty((Collection)sysDepartments)) {
                    sysDepartments = new HashSet<SysDepartment>();
                }
                sysDepartments.add(sysDepartment);
                employee.setDepartments(sysDepartments);
            }).collect(Collectors.toList());
        }
        return new ArrayList<SysEmployee>();
    }

    public List<SysOwnership> getOwnerships() {
        if (CollectionUtils.isNotEmpty(this.employees)) {
            return this.employees.stream().map(employee -> {
                SysOwnership sysOwnership = new SysOwnership();
                sysOwnership.setEmployeeId(employee.getEmployeeId());
                sysOwnership.setDepartmentId(this.departmentId);
                sysOwnership.setOrganizationId(this.organizationId);
                return sysOwnership;
            }).collect(Collectors.toList());
        }
        return new ArrayList<SysOwnership>();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("organizationId", (Object)this.organizationId).add("departmentId", (Object)this.departmentId).toString();
    }
}

