/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.converter;

import cn.herodotus.engine.logic.upms.entity.security.SysElement;
import cn.herodotus.engine.logic.upms.enums.ElementCategory;
import cn.herodotus.engine.rest.servlet.upms.converter.SysElementToTreeNodeConverter;
import cn.herodotus.engine.rest.servlet.upms.dto.Elements;
import cn.hutool.v7.core.tree.MapTree;
import cn.hutool.v7.core.tree.TreeNode;
import cn.hutool.v7.core.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public class SysElementsToElementsConverter
implements Converter<List<SysElement>, Elements> {
    private final Converter<SysElement, TreeNode<String>> toTreeNode = new SysElementToTreeNodeConverter();

    public Elements convert(List<SysElement> source) {
        Map<ElementCategory, List<SysElement>> groupedElements = source.stream().collect(Collectors.groupingBy(SysElement::getElementCategory));
        Elements elements = new Elements();
        elements.setMenus(this.toTreeNodes(groupedElements.get(ElementCategory.MENU)));
        elements.setButtons(elements.getButtons());
        return elements;
    }

    private List<MapTree<String>> toTreeNodes(List<SysElement> sysElements) {
        if (ObjectUtils.isNotEmpty(sysElements)) {
            List treeNodes = sysElements.stream().map(arg_0 -> this.toTreeNode.convert(arg_0)).collect(Collectors.toList());
            return TreeUtil.build(treeNodes, (Object)"0");
        }
        return new ArrayList<MapTree<String>>();
    }
}

