/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.converter;

import cn.herodotus.engine.core.definition.domain.view.vue.BaseMeta;
import cn.herodotus.engine.core.definition.domain.view.vue.ChildMeta;
import cn.herodotus.engine.core.definition.domain.view.vue.ParentMeta;
import cn.herodotus.engine.core.definition.domain.view.vue.RootMeta;
import cn.herodotus.engine.core.definition.utils.WellFormedUtils;
import cn.herodotus.engine.logic.upms.entity.security.SysElement;
import cn.hutool.v7.core.tree.TreeNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class SysElementToTreeNodeConverter
implements Converter<SysElement, TreeNode<String>> {
    public TreeNode<String> convert(SysElement sysMenu) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId((Object)sysMenu.getElementId());
        treeNode.setName((CharSequence)sysMenu.getPath());
        treeNode.setWeight((Comparable)sysMenu.getRanking());
        treeNode.setParentId((Object)WellFormedUtils.parentId((String)sysMenu.getParentId()));
        treeNode.setExtra(this.getExtra(sysMenu));
        return treeNode;
    }

    private Map<String, Object> getExtra(SysElement sysMenu) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)sysMenu.getParentId())) {
            RootMeta meta = new RootMeta();
            meta.setSort(sysMenu.getRanking());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("redirect", sysMenu.getRedirect());
        } else if (BooleanUtils.isTrue((Boolean)sysMenu.getHaveChild())) {
            ParentMeta meta = new ParentMeta();
            meta.setHideAllChild(sysMenu.getHideAllChild());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("componentName", sysMenu.getName());
        } else {
            ChildMeta meta = new ChildMeta();
            meta.setDetailContent(sysMenu.getDetailContent());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("componentName", sysMenu.getName());
        }
        extra.put("componentPath", sysMenu.getComponent());
        extra.put("scenario", sysMenu.getMenuScenario().name());
        return extra;
    }

    private void setBaseMeta(SysElement sysMenu, BaseMeta meta) {
        meta.setIcon(sysMenu.getIcon());
        meta.setTitle(sysMenu.getTitle());
        meta.setIgnoreAuth(sysMenu.getIgnoreAuth());
        meta.setNotKeepAlive(sysMenu.getNotKeepAlive());
    }
}

