/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.security;

import cn.herodotus.engine.core.definition.domain.BaseDomain;
import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.entity.security.SysUser;
import cn.herodotus.engine.logic.upms.service.security.SysUserService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.herodotus.engine.web.core.annotation.Crypto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security/user"})
@Tags(value={@Tag(name="\u7528\u6237\u5b89\u5168\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u7cfb\u7edf\u7528\u6237\u7ba1\u7406\u63a5\u53e3")})
public class SysUserController
extends AbstractJpaWriteableController<SysUser, String> {
    private final SysUserService sysUserService;

    public SysUserController(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public BaseJpaWriteableService<SysUser, String> getService() {
        return this.sysUserService;
    }

    @Operation(summary="\u7ed9\u7528\u6237\u5206\u914d\u89d2\u8272", description="\u7ed9\u7528\u6237\u5206\u914d\u89d2\u8272", requestBody=@RequestBody(content={@Content(mediaType="application/x-www-form-urlencoded")}), responses={@ApiResponse(description="\u5df2\u5206\u914d\u89d2\u8272\u7684\u7528\u6237\u6570\u636e", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="userId", required=true, description="userId"), @Parameter(name="roles[]", required=true, description="\u89d2\u8272\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @PutMapping
    public Result<SysUser> assign(@RequestParam(name="userId") String userId, @RequestParam(name="roles[]") String[] roles) {
        SysUser sysUser = this.sysUserService.assign(userId, roles);
        return this.result((BaseDomain)sysUser);
    }

    @Operation(summary="\u4fee\u6539\u5bc6\u7801", description="\u4fee\u6539\u7528\u6237\u4f7f\u7528\u5bc6\u7801\uff0c\u9ed8\u8ba4\u4f7f\u7528\u52a0\u5bc6\u8bf7\u6c42\u4f20\u8f93", requestBody=@RequestBody(content={@Content(mediaType="application/x-www-form-urlencoded")}), responses={@ApiResponse(description="\u4fee\u6539\u5bc6\u7801\u540e\u7684\u7528\u6237\u4fe1\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="userId", required=true, description="userId"), @Parameter(name="password", required=true, description="\u89d2\u8272\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @Crypto(responseEncrypt=false)
    @PutMapping(value={"/change-password"})
    public Result<SysUser> changePassword(@RequestParam(name="userId") String userId, @RequestParam(name="password") String password) {
        SysUser sysUser = this.sysUserService.changePassword(userId, password);
        return this.result((BaseDomain)sysUser);
    }

    @Operation(summary="\u6839\u636e\u7528\u6237\u540d\u67e5\u8be2\u7cfb\u7edf\u7528\u6237", description="\u901a\u8fc7username\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u6570\u636e", responses={@ApiResponse(description="\u67e5\u8be2\u5230\u7684\u7528\u6237", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysUser.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @Parameters(value={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="\u7528\u6237\u540d")})
    @GetMapping(value={"/sign-in/{username}"})
    public Result<SysUser> findByUsername(@PathVariable(value="username") String username) {
        SysUser sysUser = this.sysUserService.findByUsername(username);
        return this.result((BaseDomain)sysUser);
    }
}

