/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.security;

import cn.herodotus.engine.core.definition.domain.BaseDomain;
import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.entity.security.SysRole;
import cn.herodotus.engine.logic.upms.service.security.SysRoleService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.herodotus.engine.web.core.annotation.AccessLimited;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security/role"})
@Tags(value={@Tag(name="\u7528\u6237\u5b89\u5168\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u7cfb\u7edf\u89d2\u8272\u7ba1\u7406\u63a5\u53e3")})
public class SysRoleController
extends AbstractJpaWriteableController<SysRole, String> {
    private final SysRoleService sysRoleService;

    public SysRoleController(SysRoleService sysRoleService) {
        this.sysRoleService = sysRoleService;
    }

    public BaseJpaWriteableService<SysRole, String> getService() {
        return this.sysRoleService;
    }

    @AccessLimited
    @Operation(summary="\u6839\u636e\u89d2\u8272\u4ee3\u7801\u67e5\u8be2\u89d2\u8272", description="\u6839\u636e\u8f93\u5165\u7684\u89d2\u8272\u4ee3\u7801\uff0c\u67e5\u8be2\u5bf9\u5e94\u7684\u89d2\u8272", responses={@ApiResponse(description="\u67e5\u8be2\u5230\u7684\u89d2\u8272", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysRole.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @Parameters(value={@Parameter(name="roleCode", in=ParameterIn.PATH, required=true, description="\u89d2\u8272\u4ee3\u7801")})
    @GetMapping(value={"/{roleCode}"})
    public Result<SysRole> findByRoleCode(@PathVariable(value="roleCode") String roleCode) {
        SysRole sysRole = this.sysRoleService.findByRoleCode(roleCode);
        return this.result((BaseDomain)sysRole);
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u89d2\u8272", description="\u83b7\u53d6\u5168\u90e8\u89d2\u8272\u6570\u636e\u5217\u8868", responses={@ApiResponse(description="\u5168\u90e8\u6570\u636e\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @GetMapping(value={"/list"})
    public Result<List<SysRole>> findAll() {
        List sysAuthorities = this.sysRoleService.findAll();
        return this.result(sysAuthorities);
    }

    @Operation(summary="\u7ed9\u89d2\u8272\u8d4b\u4e88\u6743\u9650", description="\u4e3a\u89d2\u8272\u8d4b\u4e88\u6743\u9650", requestBody=@RequestBody(content={@Content(mediaType="application/x-www-form-urlencoded")}), responses={@ApiResponse(description="\u5df2\u5206\u914d\u6743\u9650\u7684\u89d2\u8272\u6570\u636e", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="roleId", required=true, description="\u89d2\u8272ID"), @Parameter(name="permissions[]", required=true, description="\u6743\u9650\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @PutMapping
    public Result<SysRole> assign(@RequestParam(name="roleId") String roleId, @RequestParam(name="permissions[]") String[] permissions) {
        SysRole sysRole = this.sysRoleService.assign(roleId, permissions);
        return this.result((BaseDomain)sysRole);
    }
}

