/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.security;

import cn.herodotus.engine.core.definition.domain.BaseDomain;
import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.enums.ApplicationType;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.entity.security.SysElement;
import cn.herodotus.engine.logic.upms.service.security.SysElementService;
import cn.herodotus.engine.rest.servlet.upms.converter.SysElementToTreeNodeConverter;
import cn.herodotus.engine.rest.servlet.upms.converter.SysElementsToElementsConverter;
import cn.herodotus.engine.rest.servlet.upms.dto.Elements;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.herodotus.engine.web.core.annotation.AccessLimited;
import cn.hutool.v7.core.tree.MapTree;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security/element"})
@Tags(value={@Tag(name="\u7528\u6237\u5b89\u5168\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u7cfb\u7edf\u83dc\u5355\u7ba1\u7406\u63a5\u53e3")})
public class SysElementController
extends AbstractJpaWriteableController<SysElement, String> {
    private final Converter<List<SysElement>, Elements> toElements;
    private final SysElementService sysElementService;

    public SysElementController(SysElementService sysElementService) {
        this.sysElementService = sysElementService;
        this.toElements = new SysElementsToElementsConverter();
    }

    public BaseJpaWriteableService<SysElement, String> getService() {
        return this.sysElementService;
    }

    @Operation(summary="\u83b7\u53d6\u83dc\u5355\u6811", description="\u83b7\u53d6\u7cfb\u7edf\u83dc\u5355\u6811", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))})})
    @GetMapping(value={"/tree"})
    public Result<List<MapTree<String>>> findTree() {
        List sysMenus = this.sysElementService.findAll();
        return this.result(sysMenus, new SysElementToTreeNodeConverter());
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u524d\u7aef\u8d44\u6e90", description="\u6839\u636e\u7528\u6237ID\u8fd4\u56de\u524d\u7aef\u6240\u9700\u7684\u5fc5\u8981\u8d44\u6e90", responses={@ApiResponse(description="\u8d44\u6e90", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))})})
    @Parameters(value={@Parameter(name="roles[]", required=true, description="\u89d2\u8272\u4ee3\u7801\u7ec4\u6210\u7684\u6570\u7ec4")})
    @GetMapping(value={"/resources"})
    public Result<Elements> findAllByRoleCodes(@RequestParam(name="roles[]") String[] roles) {
        List sysElements = this.sysElementService.findAllByRoleCodes(ApplicationType.WEB, roles);
        return this.result((BaseDomain)((Elements)this.toElements.convert((Object)sysElements)));
    }

    @Operation(summary="\u6a21\u7cca\u6761\u4ef6\u67e5\u8be2\u524d\u7aef\u5143\u7d20", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u6a21\u7cca\u67e5\u8be2\u524d\u7aef\u5143\u7d20", responses={@ApiResponse(description="\u524d\u7aef\u5143\u7d20\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="path", description="\u7ec4\u4ef6\u8def\u5f84"), @Parameter(name="title", description="\u7ec4\u4ef6\u6807\u9898")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="path", required=false) String path, @RequestParam(value="title", required=false) String title) {
        Page pages = this.sysElementService.findByCondition(pageNumber.intValue(), pageSize.intValue(), path, title);
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u7ed9\u524d\u7aef\u5143\u7d20\u5206\u914d\u89d2\u8272", description="\u7ed9\u524d\u7aef\u5143\u7d20\u5206\u914d\u89d2\u8272")
    @Parameters(value={@Parameter(name="elementId", required=true, description="\u5143\u7d20ID"), @Parameter(name="roles[]", required=true, description="\u89d2\u8272\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @PutMapping
    public Result<SysElement> assign(@RequestParam(name="elementId") String elementId, @RequestParam(name="roles[]") String[] roles) {
        SysElement sysElement = this.sysElementService.assign(elementId, roles);
        return this.result((BaseDomain)sysElement);
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u524d\u7aef\u5143\u7d20\u63a5\u53e3", description="\u83b7\u53d6\u5168\u90e8\u524d\u7aef\u5143\u7d20\u63a5\u53e3", responses={@ApiResponse(description="\u5143\u7d20\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @GetMapping(value={"/list"})
    public Result<List<SysElement>> findAll() {
        List sysElements = this.sysElementService.findAll();
        return this.result(sysElements);
    }

    @AccessLimited
    @Operation(summary="\u6839\u636eID\u67e5\u8be2\u5143\u7d20", description="\u6839\u636eID\u67e5\u8be2\u5143\u7d20", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="id", required=true, in=ParameterIn.PATH, description="\u5b9e\u4f53ID\uff0c@Id\u6ce8\u89e3\u5bf9\u5e94\u7684\u5b9e\u4f53\u5c5e\u6027")})
    @GetMapping(value={"/{id}"})
    public Result<SysElement> findById(@PathVariable String id) {
        return super.findById((Serializable)((Object)id));
    }
}

