/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.security;

import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.entity.security.SysDictionary;
import cn.herodotus.engine.logic.upms.service.security.SysDictionaryService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.herodotus.engine.web.core.annotation.AccessLimited;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security/dictionary"})
@Tags(value={@Tag(name="\u7528\u6237\u5b89\u5168\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u6570\u636e\u5b57\u5178\u7ba1\u7406\u63a5\u53e3")})
public class SysDictionaryController
extends AbstractJpaWriteableController<SysDictionary, String> {
    private final SysDictionaryService sysDictionaryService;

    public SysDictionaryController(SysDictionaryService sysDictionaryService) {
        this.sysDictionaryService = sysDictionaryService;
    }

    public BaseJpaWriteableService<SysDictionary, String> getService() {
        return this.sysDictionaryService;
    }

    @Operation(summary="\u6a21\u7cca\u6761\u4ef6\u67e5\u8be2\u6570\u636e\u5b57\u5178", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u6a21\u7cca\u67e5\u8be2\u6570\u636e\u5b57\u5178", responses={@ApiResponse(description="\u6570\u636e\u5b57\u5178\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="category", description="\u5b57\u5178\u5206\u7c7b"), @Parameter(name="name", description="\u5b57\u5178\u679a\u4e3e\u5b57\u9762\u91cf"), @Parameter(name="label", description="\u5b57\u5178\u679a\u4e3e\u663e\u793a\u503c")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="category", required=false) String category, @RequestParam(value="name", required=false) String name, @RequestParam(value="label", required=false) String label) {
        Page pages = this.sysDictionaryService.findByCondition(pageNumber.intValue(), pageSize.intValue(), category, name, label);
        return this.resultFromPage(pages);
    }

    @AccessLimited
    @Operation(summary="\u6839\u636e\u5b57\u5178\u5206\u7c7b\u67e5\u8be2\u6570\u636e\u5b57\u5178", description="\u6839\u636e\u5b57\u5178\u5206\u7c7b\u67e5\u8be2\u6570\u636e\u5b57\u5178", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="category", required=true, in=ParameterIn.PATH, description="\u5b57\u5178\u5206\u7c7b")})
    @GetMapping(value={"/items/{category}"})
    public Result<List<SysDictionary>> findAllByCategory(@PathVariable String category) {
        List dictionaries = this.sysDictionaryService.findAllByCategory(category);
        return this.result(dictionaries);
    }

    @AccessLimited
    @Operation(summary="\u6839\u636e\u5b57\u5178\u5206\u7c7b\u67e5\u8be2\u6570\u636e\u5b57\u5178", description="\u6839\u636e\u5b57\u5178\u5206\u7c7b\u67e5\u8be2\u6570\u636e\u5b57\u5178", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="categories", required=true, description="\u591a\u4e2a\u5b57\u5178\u5206\u7c7b\uff0c\u4ee5\u9017\u53f7\u5206\u9694\u7684\u5b57\u7b26\u4e32")})
    @GetMapping(value={"/items"})
    public Result<Map<String, List<SysDictionary>>> findByCategories(@RequestParam(value="categories") Set<String> categories) {
        Map dictionaries = this.sysDictionaryService.findByCategories(categories);
        if (null == dictionaries) {
            return Result.failure((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        if (MapUtils.isNotEmpty((Map)dictionaries)) {
            return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)dictionaries);
        }
        return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
    }
}

