/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.hr;

import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.converter.SysOrganizationToTreeNodeConverter;
import cn.herodotus.engine.logic.upms.entity.hr.SysOrganization;
import cn.herodotus.engine.logic.upms.enums.OrganizationCategory;
import cn.herodotus.engine.logic.upms.service.hr.SysOrganizationService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.hutool.v7.core.tree.MapTree;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hr/organization"})
@Tag(name="\u5355\u4f4d\u7ba1\u7406\u63a5\u53e3")
@Validated
public class SysOrganizationController
extends AbstractJpaWriteableController<SysOrganization, String> {
    private final SysOrganizationService sysOrganizationService;

    public SysOrganizationController(SysOrganizationService sysOrganizationService) {
        this.sysOrganizationService = sysOrganizationService;
    }

    public BaseJpaWriteableService<SysOrganization, String> getService() {
        return this.sysOrganizationService;
    }

    private OrganizationCategory parseOrganizationCategory(Integer category) {
        if (ObjectUtils.isEmpty((Object)category)) {
            return null;
        }
        return OrganizationCategory.get((Integer)category);
    }

    private List<SysOrganization> getSysOrganizations(Integer category) {
        return this.sysOrganizationService.findAll(this.parseOrganizationCategory(category));
    }

    @Operation(summary="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u5355\u4f4d", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u67e5\u8be2\u5355\u4f4d\u5206\u9875\u4fe1\u606f", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysOrganization.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="category", description="\u673a\u6784\u5206\u7c7b \uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="category", required=false) Integer category) {
        Page pages = this.sysOrganizationService.findByCondition(pageNumber.intValue(), pageSize.intValue(), this.parseOrganizationCategory(category));
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u5355\u4f4d", description="\u83b7\u53d6\u5168\u90e8\u5355\u4f4d\u6570\u636e", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysOrganization.class))})})
    @Parameters(value={@Parameter(name="category", description="\u673a\u6784\u5206\u7c7b \uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09")})
    @GetMapping(value={"/list"})
    public Result<List<SysOrganization>> findAll(@RequestParam(value="category", required=false) Integer category) {
        List<SysOrganization> sysOrganizations = this.getSysOrganizations(category);
        return this.result(sysOrganizations);
    }

    @Operation(summary="\u83b7\u53d6\u5355\u4f4d\u6811", description="\u83b7\u53d6\u5168\u90e8\u5355\u4f4d\u6570\u636e\uff0c\u8f6c\u6362\u4e3a\u6811\u5f62\u7ed3\u6784", responses={@ApiResponse(description="\u5355\u4f4d\u6811", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysOrganization.class))})})
    @Parameters(value={@Parameter(name="category", description="\u673a\u6784\u5206\u7c7b \uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09")})
    @GetMapping(value={"/tree"})
    public Result<List<MapTree<String>>> findTree(@RequestParam(value="category", required=false) Integer category) {
        List<SysOrganization> sysOrganizations = this.getSysOrganizations(category);
        return this.result(sysOrganizations, (Converter)new SysOrganizationToTreeNodeConverter());
    }

    @DeleteMapping(value={"/{id}"})
    public Result<String> delete(@PathVariable String id) {
        boolean isInUse = this.sysOrganizationService.isInUse(id);
        if (isInUse) {
            return Result.failure((String)"\u8be5\u5355\u4f4d\u88ab\u90e8\u5206\u90e8\u95e8\u5f15\u7528\uff0c\u8bf7\u5220\u9664\u5173\u8054\u5173\u7cfb\u540e\u518d\u5220\u9664\uff01");
        }
        this.sysOrganizationService.deleteById(id);
        return Result.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

