/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.hr;

import cn.herodotus.engine.core.definition.domain.BaseDomain;
import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.entity.hr.SysEmployee;
import cn.herodotus.engine.logic.upms.enums.Gender;
import cn.herodotus.engine.logic.upms.enums.Identity;
import cn.herodotus.engine.logic.upms.service.hr.SysEmployeeService;
import cn.herodotus.engine.rest.servlet.upms.dto.AllocatableDeploy;
import cn.herodotus.engine.rest.servlet.upms.dto.AllocatableRemove;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hr/employee"})
@Tag(name="\u4eba\u5458\u7ba1\u7406\u63a5\u53e3")
public class SysEmployeeController
extends AbstractJpaWriteableController<SysEmployee, String> {
    private final SysEmployeeService sysEmployeeService;

    public SysEmployeeController(SysEmployeeService sysEmployeeService) {
        this.sysEmployeeService = sysEmployeeService;
    }

    private Gender parseGender(Integer gender) {
        if (ObjectUtils.isNotEmpty((Object)gender)) {
            return Gender.get((Integer)gender);
        }
        return null;
    }

    private Identity parseIdentity(Integer identity) {
        if (ObjectUtils.isNotEmpty((Object)identity)) {
            return Identity.get((Integer)identity);
        }
        return null;
    }

    public BaseJpaWriteableService<SysEmployee, String> getService() {
        return this.sysEmployeeService;
    }

    @Operation(summary="\u6a21\u7cca\u6761\u4ef6\u67e5\u8be2\u4eba\u5458", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u6a21\u7cca\u67e5\u8be2\u4eba\u5458\u4fe1\u606f", responses={@ApiResponse(description="\u4eba\u5458\u5206\u9875\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="employeeName", description="\u4eba\u5458\u59d3\u540d"), @Parameter(name="mobilePhoneNumber", description="\u624b\u673a\u53f7\u7801"), @Parameter(name="officePhoneNumber", description="\u529e\u516c\u7535\u8bdd"), @Parameter(name="email", description="\u7535\u5b50\u90ae\u4ef6"), @Parameter(name="pkiEmail", description="\u8bc1\u4e66\u6807\u8bc6"), @Parameter(name="gender", description="\u6027\u522b \uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09"), @Parameter(name="identity", description="\u8eab\u4efd\uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="employeeName", required=false) String employeeName, @RequestParam(value="mobilePhoneNumber", required=false) String mobilePhoneNumber, @RequestParam(value="officePhoneNumber", required=false) String officePhoneNumber, @RequestParam(value="email", required=false) String email, @RequestParam(value="pkiEmail", required=false) String pkiEmail, @RequestParam(value="gender", required=false) Integer gender, @RequestParam(value="identity", required=false) Integer identity) {
        Page pages = this.sysEmployeeService.findByCondition(pageNumber.intValue(), pageSize.intValue(), employeeName, mobilePhoneNumber, officePhoneNumber, email, pkiEmail, this.parseGender(gender), this.parseIdentity(identity));
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u7ed9\u4eba\u5458\u5206\u914d\u7528\u6237", description="\u4e3a\u4eba\u5458\u521b\u5efa\u7528\u6237\uff0c\u751f\u6210\u9ed8\u8ba4\u7528\u6237\u4fe1\u606f\uff0c\u8ba9\u4eba\u5458\u53ef\u4ee5\u8fdb\u5165\u7cfb\u7edf", responses={@ApiResponse(description="\u5df2\u5206\u914d\u7528\u6237\u7684\u4eba\u5458\u4fe1\u606f", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysEmployee.class))})})
    @Parameters(value={@Parameter(name="employeeId", description="\u4eba\u5458ID")})
    @PutMapping
    public Result<SysEmployee> authorize(@RequestParam(value="employeeId") String employeeId) {
        SysEmployee sysEmployee = this.sysEmployeeService.authorize(employeeId);
        return this.result((BaseDomain)sysEmployee);
    }

    @Operation(summary="\u67e5\u8be2\u53ef\u8bbe\u7f6e\u4eba\u4e8b\u5f52\u5c5e\u7684\u4eba\u5458", description="\u6839\u636e\u8f93\u5165\u7684\u5355\u4f4d\u548c\u90e8\u95e8\uff0c\u5206\u9875\u67e5\u8be2\u5f53\u524d\u90e8\u95e8\u4e0b\u672a\u8bbe\u7f6e\u4eba\u4e8b\u5f52\u5c5e\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u6392\u9664\u4e86\u5df2\u7ecf\u8bbe\u7f6e\u7684\u4eba\u5458\u4fe1\u606f", responses={@ApiResponse(description="\u53ef\u914d\u7f6e\u4eba\u5458\u5206\u9875\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="organizationId", required=true, description="\u5355\u4f4dID"), @Parameter(name="departmentId", required=true, description="\u90e8\u95e8ID"), @Parameter(name="employeeName", description="\u4eba\u5458\u59d3\u540d"), @Parameter(name="mobilePhoneNumber", description="\u624b\u673a\u53f7\u7801"), @Parameter(name="email", description="\u7535\u5b50\u90ae\u4ef6"), @Parameter(name="gender", description="\u6027\u522b \uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09"), @Parameter(name="identity", description="\u8eab\u4efd\uff08\u7d22\u5f15\u6570\u5b57\u503c\uff09")})
    @GetMapping(value={"/allocatable"})
    public Result<Map<String, Object>> findAllocatable(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @NotBlank @RequestParam(value="organizationId") String organizationId, @NotBlank @RequestParam(value="departmentId") String departmentId, @RequestParam(value="employeeName", required=false) String employeeName, @RequestParam(value="mobilePhoneNumber", required=false) String mobilePhoneNumber, @RequestParam(value="email", required=false) String email, @RequestParam(value="gender", required=false) Integer gender, @RequestParam(value="identity", required=false) Integer identity) {
        Page pages = this.sysEmployeeService.findAllocatable(pageNumber.intValue(), pageSize.intValue(), organizationId, departmentId, employeeName, mobilePhoneNumber, email, this.parseGender(gender), this.parseIdentity(identity));
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u67e5\u8be2\u5df2\u8bbe\u7f6e\u5f52\u5c5e\u5173\u7cfb\u7684\u4eba\u5458", description="\u6839\u636e\u8f93\u5165\u7684\u90e8\u95e8\uff0c\u5206\u9875\u67e5\u8be2\u5f53\u524d\u90e8\u95e8\u4e0b\u5df2\u8bbe\u7f6e\u4eba\u4e8b\u5f52\u5c5e\u7684\u4eba\u5458\u4fe1\u606f", responses={@ApiResponse(description="\u53ef\u914d\u7f6e\u4eba\u5458\u5206\u9875\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="departmentId", required=true, description="\u90e8\u95e8ID")})
    @GetMapping(value={"/assigned"})
    public Result<Map<String, Object>> findAssigned(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @NotBlank @RequestParam(value="departmentId") String departmentId) {
        Page pages = this.sysEmployeeService.findByDepartmentId(pageNumber.intValue(), pageSize.intValue(), departmentId);
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u8bbe\u7f6e\u4eba\u4e8b\u5f52\u5c5e", description="\u6839\u636e\u8f93\u5165\u7684\u5355\u4f4d\u548c\u90e8\u95e8\uff0c\u8bbe\u7f6e\u5f53\u524d\u90e8\u95e8\u4e0b\u672a\u8bbe\u7f6e\u4eba\u4e8b\u5f52\u5c5e\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u6392\u9664\u4e86\u5df2\u7ecf\u8bbe\u7f6e\u7684\u4eba\u5458\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u8bbe\u7f6e\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="allocatableDeploy", required=true, description="\u5f53\u524d\u9875\u7801", schema=@Schema(implementation=AllocatableDeploy.class))})
    @PostMapping(value={"/allocatable"})
    public Result<Boolean> saveAllocatable(@RequestBody AllocatableDeploy allocatableDeploy) {
        boolean isSuccess = ObjectUtils.isNotEmpty((Object)((Object)allocatableDeploy)) ? this.sysEmployeeService.deployAllocatable(allocatableDeploy.getEmployees(), allocatableDeploy.getOwnerships()) : false;
        return this.result(isSuccess);
    }

    @Operation(summary="\u5220\u9664\u4eba\u5458\u5f52\u5c5e\u5173\u7cfb", description="\u6839\u636e\u5f52\u5c5e\u5173\u7cfb\u3001\u90e8\u95e8\u548c\u4eba\u5458\u7684ID\uff0c\u5220\u9664\u5f52\u5c5e\u5173\u7cfb\u4ee5\u53ca\u4eba\u5458\u4e0e\u90e8\u95e8\u4e4b\u95f4\u7684\u5173\u8054\u5173\u7cfb", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u5220\u9664\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="allocatableRemove", required=true, description="\u589e\u52a0\u4eba\u5458\u5f52\u5c5e\u53c2\u6570BO\u5bf9\u8c61", schema=@Schema(implementation=AllocatableRemove.class))})
    @DeleteMapping(value={"/allocatable"})
    public Result<Boolean> deleteAllocatable(@RequestBody AllocatableRemove allocatableRemove) {
        boolean isSuccess = ObjectUtils.isNotEmpty((Object)((Object)allocatableRemove)) ? this.sysEmployeeService.removeAllocatable(allocatableRemove.getOrganizationId(), allocatableRemove.getDepartmentId(), allocatableRemove.getEmployeeId()) : false;
        return this.result(isSuccess);
    }

    @Operation(summary="\u6839\u636e\u59d3\u540d\u67e5\u8be2\u4eba\u5458", description="\u6839\u636e\u8f93\u5165\u7684\u4eba\u5458\u59d3\u540d\uff0c\u5206\u9875\u67e5\u8be2\u5f53\u524d\u90e8\u95e8\u4e0b\u5df2\u8bbe\u7f6e\u4eba\u4e8b\u5f52\u5c5e\u7684\u4eba\u5458\u4fe1\u606f", responses={@ApiResponse(description="\u67e5\u8be2\u5230\u7684\u4eba\u5458", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysEmployee.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @Parameters(value={@Parameter(name="employeeName", in=ParameterIn.PATH, required=true, description="\u5f53\u524d\u9875\u7801")})
    @GetMapping(value={"/{employeeName}"})
    public Result<SysEmployee> findByEmployeeName(@PathVariable(value="employeeName") String employeeName) {
        SysEmployee sysEmployee = this.sysEmployeeService.findByEmployeeName(employeeName);
        return this.result((BaseDomain)sysEmployee);
    }
}

