/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.controller.hr;

import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.upms.converter.SysDepartmentToTreeNodeConverter;
import cn.herodotus.engine.logic.upms.entity.hr.SysDepartment;
import cn.herodotus.engine.logic.upms.service.hr.SysDepartmentService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.hutool.v7.core.tree.MapTree;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hr/department"})
@Tag(name="\u90e8\u95e8\u7ba1\u7406\u63a5\u53e3")
@Validated
public class SysDepartmentController
extends AbstractJpaWriteableController<SysDepartment, String> {
    private final SysDepartmentService sysDepartmentService;

    public SysDepartmentController(SysDepartmentService sysDepartmentService) {
        this.sysDepartmentService = sysDepartmentService;
    }

    public BaseJpaWriteableService<SysDepartment, String> getService() {
        return this.sysDepartmentService;
    }

    private List<SysDepartment> getSysDepartments(String organizationId) {
        return this.sysDepartmentService.findAll(organizationId);
    }

    @Operation(summary="\u6761\u4ef6\u67e5\u8be2\u90e8\u95e8\u5206\u9875\u6570\u636e", description="\u6839\u636e\u8f93\u5165\u7684\u5b57\u6bb5\u6761\u4ef6\u67e5\u8be2\u90e8\u95e8\u4fe1\u606f", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysDepartment.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="organizationId", description="\u5355\u4f4dID")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="organizationId", required=false) String organizationId) {
        Page pages = this.sysDepartmentService.findByCondition(pageNumber.intValue(), pageSize.intValue(), organizationId);
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u83b7\u53d6\u90e8\u95e8\u5217\u8868", description="\u6839\u636e\u5355\u4f4dID\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5217\u8868", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysDepartment.class))})})
    @Parameters(value={@Parameter(name="organizationId", required=true, description="\u5355\u4f4dID")})
    @GetMapping(value={"/list"})
    public Result<List<SysDepartment>> findAllByOrganizationId(@RequestParam(value="organizationId", required=false) String organizationId) {
        List<SysDepartment> sysDepartments = this.getSysDepartments(organizationId);
        return this.result(sysDepartments);
    }

    @Operation(summary="\u83b7\u53d6\u90e8\u95e8\u6811", description="\u6839\u636e\u5355\u4f4dID\u83b7\u53d6\u90e8\u95e8\u6570\u636e\uff0c\u8f6c\u6362\u4e3a\u6811\u5f62\u7ed3\u6784", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=SysDepartment.class))})})
    @Parameters(value={@Parameter(name="organizationId", required=true, description="\u5355\u4f4dID")})
    @GetMapping(value={"/tree"})
    public Result<List<MapTree<String>>> findTree(@RequestParam(value="organizationId", required=false) String organizationId) {
        List<SysDepartment> sysDepartments = this.getSysDepartments(organizationId);
        return this.result(sysDepartments, (Converter)new SysDepartmentToTreeNodeConverter());
    }
}

