/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.upms.config;

import cn.herodotus.engine.assistant.access.condition.ConditionalOnJustAuthEnabled;
import cn.herodotus.engine.assistant.access.condition.ConditionalOnSmsEnabled;
import cn.herodotus.engine.assistant.access.condition.ConditionalOnWxappEnabled;
import cn.herodotus.engine.logic.upms.annotation.EnableHerodotusLogicUpms;
import cn.herodotus.engine.rest.servlet.upms.controller.social.JustAuthAccessController;
import cn.herodotus.engine.rest.servlet.upms.controller.social.PhoneNumberAccessController;
import cn.herodotus.engine.rest.servlet.upms.controller.social.WxappAccessController;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableHerodotusLogicUpms
@ComponentScan(basePackages={"cn.herodotus.engine.rest.servlet.upms.controller.assistant", "cn.herodotus.engine.rest.servlet.upms.controller.hr", "cn.herodotus.engine.rest.servlet.upms.controller.security"})
public class RestServletUpmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestServletUpmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Rest Servlet Upms] Configure.");
    }

    @Bean
    @ConditionalOnSmsEnabled
    @ConditionalOnMissingBean
    public PhoneNumberAccessController phoneNumberAccessController() {
        PhoneNumberAccessController phoneNumberAuthenticationController = new PhoneNumberAccessController();
        log.trace("[Herodotus] |- Bean [Phone Number Access Controller] Configure.");
        return phoneNumberAuthenticationController;
    }

    @Bean
    @ConditionalOnJustAuthEnabled
    @ConditionalOnMissingBean
    public JustAuthAccessController justAuthSignInController() {
        JustAuthAccessController justAuthAuthenticationController = new JustAuthAccessController();
        log.trace("[Herodotus] |- Bean [Just Auth Access Controller] Configure.");
        return justAuthAuthenticationController;
    }

    @Bean
    @ConditionalOnWxappEnabled
    @ConditionalOnMissingBean
    public WxappAccessController wxappAccessController() {
        WxappAccessController wxappAccessController = new WxappAccessController();
        log.trace("[Herodotus] |- Bean [Wxapp Access Controller] Configure.");
        return wxappAccessController;
    }
}

