/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.message.controller;

import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.message.entity.Notification;
import cn.herodotus.engine.logic.message.enums.NotificationCategory;
import cn.herodotus.engine.logic.message.service.NotificationService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/notification"})
@Tags(value={@Tag(name="\u6d88\u606f\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u901a\u77e5\u7ba1\u7406\u63a5\u53e3")})
public class NotificationController
extends AbstractJpaWriteableController<Notification, String> {
    private final NotificationService notificationService;

    public NotificationController(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public BaseJpaWriteableService<Notification, String> getService() {
        return this.notificationService;
    }

    @Operation(summary="\u6761\u4ef6\u67e5\u8be2\u901a\u77e5\u4fe1\u606f\u5206\u9875\u6570\u636e", description="\u6839\u636e\u8f93\u5165\u7684\u5b57\u6bb5\u6761\u4ef6\u67e5\u8be2\u901a\u77e5\u4fe1\u606f", responses={@ApiResponse(description="\u8be6\u60c5\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801", schema=@Schema(type="integer")), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf", schema=@Schema(type="integer")), @Parameter(name="userId", required=true, description="\u7528\u6237ID"), @Parameter(name="category", description="\u901a\u77e5\u7c7b\u522b", schema=@Schema(type="integer")), @Parameter(name="read", description="\u662f\u5426\u5df2\u8bfb", schema=@Schema(type="boolean"))})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @NotBlank @RequestParam(value="userId") String userId, @RequestParam(value="category", required=false) Integer category, @RequestParam(value="read", required=false) Boolean read) {
        NotificationCategory notificationCategory = NotificationCategory.get((Integer)category);
        if (ObjectUtils.isNotEmpty((Object)notificationCategory) && notificationCategory == NotificationCategory.ANNOUNCEMENT) {
            this.notificationService.pullAnnouncements(userId);
        }
        Page pages = this.notificationService.findByCondition(pageNumber.intValue(), pageSize.intValue(), userId, notificationCategory, read);
        return this.resultFromPage(pages);
    }

    @Operation(summary="\u5168\u90e8\u901a\u77e5\u5df2\u8bfb", description="\u6839\u636e\u7528\u6237ID\u8bbe\u7f6e\u8be5\u7528\u6237\u7684\u5168\u90e8\u901a\u77e5\u4e3a\u5df2\u8bfb", responses={@ApiResponse(description="\u5f71\u54cd\u6570\u636e\u6761\u76ee\u6570", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237ID")})
    @PutMapping(value={"/all-read"})
    public Result<Integer> setAllRead(@RequestParam(value="userId") String userId) {
        Integer result = this.notificationService.setAllRead(userId);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)result);
    }
}

