/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.servlet.message.controller;

import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.jpa.service.BaseJpaWriteableService;
import cn.herodotus.engine.logic.message.entity.DialogueDetail;
import cn.herodotus.engine.logic.message.service.DialogueDetailService;
import cn.herodotus.engine.web.api.servlet.AbstractJpaWriteableController;
import cn.herodotus.engine.web.core.annotation.Idempotent;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/dialogue/detail"})
@Tags(value={@Tag(name="\u6d88\u606f\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u79c1\u4fe1\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u79c1\u4fe1\u8be6\u60c5\u7ba1\u7406\u63a5\u53e3")})
public class DialogueDetailController
extends AbstractJpaWriteableController<DialogueDetail, String> {
    private final DialogueDetailService dialogueDetailService;

    public DialogueDetailController(DialogueDetailService dialogueDetailService) {
        this.dialogueDetailService = dialogueDetailService;
    }

    public BaseJpaWriteableService<DialogueDetail, String> getService() {
        return this.dialogueDetailService;
    }

    @Operation(summary="\u6761\u4ef6\u67e5\u8be2\u79c1\u4fe1\u8be6\u60c5\u5206\u9875\u6570\u636e", description="\u6839\u636e\u8f93\u5165\u7684\u5b57\u6bb5\u6761\u4ef6\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f", responses={@ApiResponse(description="\u8be6\u60c5\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801", schema=@Schema(type="integer")), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf", schema=@Schema(type="integer")), @Parameter(name="dialogueId", required=true, description="\u5bf9\u8bddID")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @NotNull @RequestParam(value="dialogueId") String dialogueId) {
        Page pages = this.dialogueDetailService.findByCondition(pageNumber.intValue(), pageSize.intValue(), dialogueId);
        return this.resultFromPage(pages);
    }

    @Idempotent
    @Operation(summary="\u6839\u636edialogueId\u5220\u9664\u79c1\u4fe1\u6574\u4e2a\u5bf9\u8bdd", description="\u6839\u636e\u5b9e\u4f53dialogueId\u5220\u9664\u79c1\u4fe1\u6574\u4e2a\u5bf9\u8bdd\uff0c\u5305\u62ec\u76f8\u5173\u8054\u7684\u5173\u8054\u6570\u636e", requestBody=@RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="id", required=true, in=ParameterIn.PATH, description="DialogueId \u5173\u8054\u79c1\u4fe1\u8054\u7cfb\u4eba\u548c\u79c1\u4fe1\u8be6\u60c5\u7684ID")})
    @DeleteMapping(value={"/dialogue/{id}"})
    public Result<String> deleteDialogueById(@PathVariable String id) {
        this.dialogueDetailService.deleteDialogueById(id);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }
}

