/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.oss.core.exception.OssErrorResponseException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssInvalidResponseException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssServerException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.converter.BucketToEntityConverter;
import cn.herodotus.engine.oss.minio.definition.pool.MinioClientObjectPool;
import cn.herodotus.engine.oss.minio.definition.service.BaseMinioService;
import cn.herodotus.engine.oss.minio.entity.BucketEntity;
import io.minio.BucketExistsArgs;
import io.minio.ListBucketsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveBucketArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Bucket;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class BucketService
extends BaseMinioService {
    private static final Logger log = LoggerFactory.getLogger(BucketService.class);
    private final Converter<Bucket, BucketEntity> toResult = new BucketToEntityConverter();

    public BucketService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public List<BucketEntity> listBuckets(ListBucketsArgs args) {
        String function = "listBuckets";
        MinioClient minioClient = this.getMinioClient();
        try {
            List buckets = ObjectUtils.isNotEmpty((Object)args) ? minioClient.listBuckets(args) : minioClient.listBuckets();
            List<BucketEntity> list = this.toEntities(buckets);
            return list;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public boolean bucketExists(BucketExistsArgs bucketExistsArgs) {
        String function = "bucketExists";
        MinioClient minioClient = this.getMinioClient();
        try {
            boolean bl = minioClient.bucketExists(bucketExistsArgs);
            return bl;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void makeBucket(MakeBucketArgs makeBucketArgs) {
        String function = "makeBucket";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.makeBucket(makeBucketArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void removeBucket(RemoveBucketArgs removeBucketArgs) {
        String function = "removeBucket";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.removeBucket(removeBucketArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    private List<BucketEntity> toEntities(List<Bucket> buckets) {
        if (CollectionUtils.isNotEmpty(buckets)) {
            return buckets.stream().map(arg_0 -> this.toResult.convert(arg_0)).collect(Collectors.toList());
        }
        return new ArrayList<BucketEntity>();
    }
}

