/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.multipart;

import cn.herodotus.engine.oss.minio.converter.ObjectWriteResponseToEntityConverter;
import cn.herodotus.engine.oss.minio.entity.MultipartCreateEntity;
import cn.herodotus.engine.oss.minio.entity.ObjectWriteEntity;
import cn.herodotus.engine.oss.minio.service.MultipartUploadService;
import cn.herodotus.engine.oss.minio.service.PresignedService;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.http.Method;
import io.minio.messages.Part;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MultipartUploadHandler {
    private final MultipartUploadService multipartUploadService;
    private final PresignedService presignedService;

    @Autowired
    public MultipartUploadHandler(MultipartUploadService multipartUploadService, PresignedService presignedService) {
        this.multipartUploadService = multipartUploadService;
        this.presignedService = presignedService;
    }

    private String createUploadId(String bucketName, String region, String objectName) {
        CreateMultipartUploadResponse response = this.multipartUploadService.createMultipartUpload(bucketName, region, objectName, null, null);
        return response.result().uploadId();
    }

    private String createPresignedObjectUrl(String bucketName, String region, String objectName, String uploadId, int partNumber) {
        HashMap<String, String> extraQueryParams = new HashMap<String, String>();
        extraQueryParams.put("partNumber", String.valueOf(partNumber));
        extraQueryParams.put("uploadId", uploadId);
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).region(region)).object(objectName)).method(Method.PUT).extraQueryParams(extraQueryParams)).expiry(1, TimeUnit.HOURS).build();
        return this.presignedService.getPresignedObjectUrl(args);
    }

    private Part[] listParts(String bucketName, String region, String objectName, String uploadId) {
        ListPartsResponse response = this.multipartUploadService.listParts(bucketName, region, objectName, uploadId);
        List partList = response.result().partList();
        Part[] parts = new Part[partList.size()];
        return partList.toArray(parts);
    }

    private MultipartCreateEntity createMultipartUpload(String bucketName, String region, String objectName, int totalParts) {
        String uploadId = this.createUploadId(bucketName, region, objectName);
        MultipartCreateEntity entity = new MultipartCreateEntity(uploadId);
        for (int i = 0; i < totalParts; ++i) {
            String uploadUrl = this.createPresignedObjectUrl(bucketName, region, objectName, uploadId, i);
            entity.appendChunk(uploadUrl);
        }
        return entity;
    }

    public MultipartCreateEntity createMultipartUpload(String bucketName, String objectName, int totalParts) {
        return this.createMultipartUpload(bucketName, null, objectName, totalParts);
    }

    private ObjectWriteEntity completeMultipartUpload(String bucketName, String region, String objectName, String uploadId) {
        Object[] parts = this.listParts(bucketName, region, objectName, uploadId);
        if (ArrayUtils.isNotEmpty((Object[])parts)) {
            ObjectWriteResponse response = this.multipartUploadService.completeMultipartUpload(bucketName, region, objectName, uploadId, (Part[])parts);
            ObjectWriteResponseToEntityConverter toEntity = new ObjectWriteResponseToEntityConverter();
            if (ObjectUtils.isNotEmpty((Object)response)) {
                return (ObjectWriteEntity)toEntity.convert(response);
            }
        }
        return null;
    }

    public ObjectWriteEntity completeMultipartUpload(String bucketName, String objectName, String uploadId) {
        return this.completeMultipartUpload(bucketName, null, objectName, uploadId);
    }
}

