/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.definition.request;

import cn.herodotus.engine.assistant.core.utils.DateTimeUtils;
import cn.herodotus.engine.oss.minio.definition.request.ObjectRequest;
import cn.herodotus.engine.oss.minio.request.domain.RetentionRequest;
import io.minio.ObjectWriteArgs;
import io.minio.ServerSideEncryption;
import io.minio.messages.Retention;
import io.minio.messages.RetentionMode;
import java.time.ZonedDateTime;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class ObjectWriteRequest<B extends ObjectWriteArgs.Builder<B, A>, A extends ObjectWriteArgs>
extends ObjectRequest<B, A> {
    private Map<String, String> headers;
    private Map<String, String> userMetadata;
    private ServerSideEncryption serverSideEncryption;
    private Map<String, String> tags;
    private RetentionRequest retention;
    private Boolean legalHold;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public ServerSideEncryption getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public void setServerSideEncryption(ServerSideEncryption serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RetentionRequest getRetention() {
        return this.retention;
    }

    public void setRetention(RetentionRequest retention) {
        this.retention = retention;
    }

    public Boolean getLegalHold() {
        return this.legalHold;
    }

    public void setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
    }

    @Override
    public void prepare(B builder) {
        if (MapUtils.isNotEmpty(this.getHeaders())) {
            builder.headers(this.getHeaders());
        }
        if (MapUtils.isNotEmpty(this.getUserMetadata())) {
            builder.headers(this.getUserMetadata());
        }
        if (MapUtils.isNotEmpty(this.getTags())) {
            builder.headers(this.getTags());
        }
        builder.legalHold(this.getLegalHold().booleanValue());
        if (ObjectUtils.isNotEmpty((Object)this.getServerSideEncryption())) {
            builder.sse(this.getServerSideEncryption());
        }
        if (ObjectUtils.isNotEmpty((Object)this.getRetention())) {
            RetentionMode mode = RetentionMode.valueOf((String)this.getRetention().getMode());
            ZonedDateTime retainUntilDate = DateTimeUtils.stringToZonedDateTime((String)this.getRetention().getRetainUntilDate());
            builder.retention(new Retention(mode, retainUntilDate));
        }
        super.prepare(builder);
    }
}

