/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oss.minio.entity.DeleteErrorEntity;
import cn.herodotus.engine.oss.minio.entity.ItemEntity;
import cn.herodotus.engine.oss.minio.request.object.ListObjectsRequest;
import cn.herodotus.engine.oss.minio.request.object.RemoveObjectRequest;
import cn.herodotus.engine.oss.minio.request.object.RemoveObjectsRequest;
import cn.herodotus.engine.oss.minio.service.ObjectService;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.minio.ListObjectsArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/object"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8Object\u7ba1\u7406\u63a5\u53e3")})
public class ObjectController
implements Controller {
    private final ObjectService objectService;

    public ObjectController(ObjectService objectService) {
        this.objectService = objectService;
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5bf9\u8c61\u5217\u8868", description="\u83b7\u53d6\u5bf9\u8c61\u5217\u8868", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u6240\u6709\u5bf9\u8c61", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f\uff0c\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @Parameters(value={@Parameter(name="request", required=true, in=ParameterIn.PATH, description="ListObjectsRequest\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=ListObjectsRequest.class))})
    @GetMapping(value={"/list"})
    public Result<List<ItemEntity>> list(@Validated ListObjectsRequest request) {
        List<ItemEntity> items = this.objectService.listObjects((ListObjectsArgs)request.build());
        return this.result(items);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u4e00\u4e2a\u5bf9\u8c61", description="\u6839\u636e\u4f20\u5165\u7684\u53c2\u6570\u5bf9\u6307\u5b9a\u5bf9\u8c61\u8fdb\u884c\u5220\u9664", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Minio API\u65e0\u8fd4\u56de\u503c\uff0c\u6240\u4ee5\u8fd4\u56de200\u5373\u8868\u793a\u6210\u529f\uff0c\u4e0d\u6210\u529f\u4f1a\u629b\u9519", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25\uff0c\u5177\u4f53\u67e5\u770b\u9519\u8bef\u4fe1\u606f\u5185\u5bb9")})
    @Parameters(value={@Parameter(name="request", required=true, description="RemoveObjectRequest\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=RemoveObjectRequest.class))})
    @DeleteMapping
    public Result<Boolean> removeObject(@Validated @RequestBody RemoveObjectRequest request) {
        this.objectService.removeObject((RemoveObjectArgs)request.build());
        return this.result(true);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u591a\u4e2a\u5bf9\u8c61", description="\u6839\u636e\u4f20\u5165\u7684\u53c2\u6570\u5bf9\u6307\u5b9a\u591a\u4e2a\u5bf9\u8c61\u8fdb\u884c\u5220\u9664", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u8fd4\u56de\u5220\u9664\u64cd\u4f5c\u51fa\u9519\u5bf9\u8c61\u7684\u5177\u4f53\u4fe1\u606f", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))}), @ApiResponse(responseCode="200", description="\u67e5\u8be2\u6210\u529f\uff0c\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @Parameters(value={@Parameter(name="request", required=true, description="\u5220\u9664\u5bf9\u8c61\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=RemoveObjectsRequest.class))})
    @DeleteMapping(value={"/multi"})
    public Result<List<DeleteErrorEntity>> removeObjects(@Validated @RequestBody RemoveObjectsRequest request) {
        List<DeleteErrorEntity> items = this.objectService.removeObjects((RemoveObjectsArgs)request.build());
        return this.result(items);
    }
}

