/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oss.minio.entity.MultipartCreateEntity;
import cn.herodotus.engine.oss.minio.entity.ObjectWriteEntity;
import cn.herodotus.engine.oss.minio.multipart.MultipartUploadHandler;
import cn.herodotus.engine.oss.minio.request.multipart.MultipartUploadCompleteRequest;
import cn.herodotus.engine.oss.minio.request.multipart.MultipartUploadCreateRequest;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/multipart"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u5206\u7247\u4e0a\u4f20\u63a5\u53e3")})
public class MultipartUploadController
implements Controller {
    private final MultipartUploadHandler multipartUploadHandler;

    public MultipartUploadController(MultipartUploadHandler multipartUploadHandler) {
        this.multipartUploadHandler = multipartUploadHandler;
    }

    @Idempotent
    @Operation(summary="\u521b\u5efa\u5206\u7247\u4e0a\u4f20\u4fe1\u606f", description="\u521b\u5efa\u5206\u7247\u4e0a\u4f20\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="uploadId \u548c \u9884\u4e0b\u8f7d\u5730\u5740", content={@Content(mediaType="application/json", schema=@Schema(implementation=MultipartCreateEntity.class))}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="204", description="\u65e0\u7ed3\u679c"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25")})
    @Parameters(value={@Parameter(name="request", required=true, description="MultipartUploadCreateRequest\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=MultipartUploadCreateRequest.class))})
    @PostMapping(value={"/create"})
    public Result<MultipartCreateEntity> createMultipartUpload(@Validated @RequestBody MultipartUploadCreateRequest request) {
        MultipartCreateEntity result = this.multipartUploadHandler.createMultipartUpload(request.getBucketName(), request.getObjectName(), request.getSize());
        return this.result(result);
    }

    @Idempotent
    @Operation(summary="\u5b8c\u6210\u5206\u7247\u4e0a\u4f20", description="\u5b8c\u6210\u5206\u7247\u4e0a\u4f20\uff0cMinio\u5c06\u4e0a\u4f20\u5b8c\u6210\u7684\u5206\u7247\u4fe1\u606f\u8fdb\u884c\u5408\u5e76", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u7ed3\u679c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectWriteEntity.class))}), @ApiResponse(responseCode="200", description="\u64cd\u4f5c\u6210\u529f"), @ApiResponse(responseCode="204", description="\u65e0\u7ed3\u679c"), @ApiResponse(responseCode="500", description="\u64cd\u4f5c\u5931\u8d25")})
    @Parameters(value={@Parameter(name="request", required=true, description="MultipartUploadCompleteRequest\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=MultipartUploadCompleteRequest.class))})
    @PostMapping(value={"/complete"})
    public Result<ObjectWriteEntity> completeMultipartUpload(@Validated @RequestBody MultipartUploadCompleteRequest request) {
        ObjectWriteEntity entity = this.multipartUploadHandler.completeMultipartUpload(request.getBucketName(), request.getObjectName(), request.getUploadId());
        return this.result(entity);
    }
}

