/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oss.minio.domain.response.DeleteErrorResponse;
import cn.herodotus.engine.oss.minio.domain.response.ItemResponse;
import cn.herodotus.engine.oss.minio.request.object.ListObjectsRequest;
import cn.herodotus.engine.oss.minio.request.object.RemoveObjectRequest;
import cn.herodotus.engine.oss.minio.request.object.RemoveObjectsRequest;
import cn.herodotus.engine.oss.minio.service.ObjectService;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.minio.ListObjectsArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/oss/minio/object"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8Object\u7ba1\u7406\u63a5\u53e3")})
public class ObjectController
implements Controller {
    private final ObjectService objectService;

    public ObjectController(ObjectService objectService) {
        this.objectService = objectService;
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8Bucket\u63a5\u53e3", description="\u83b7\u53d6\u5168\u90e8Bucket\u63a5\u53e3")
    @Parameters(value={@Parameter(name="request", required=true, in=ParameterIn.PATH, description="\u5bf9\u8c61\u5217\u8868\u8bf7\u6c42\u53c2\u6570\u5bf9\u8c61", schema=@Schema(implementation=ListObjectsRequest.class))})
    @GetMapping(value={"/list"})
    public Result<List<ItemResponse>> list(@Validated ListObjectsRequest request) {
        List<ItemResponse> items = this.objectService.listObjects((ListObjectsArgs)request.build());
        return this.result(items);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u4e00\u4e2a\u5bf9\u8c61", description="\u6839\u636e\u4f20\u5165\u7684Object\u540d\u79f0\u5220\u9664\u5bf9\u5e94\u7684\u5bf9\u8c61", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u5df2\u4fdd\u5b58\u6570\u636e", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="request", required=true, description="\u5220\u9664\u5bf9\u8c61\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=RemoveObjectRequest.class))})
    @DeleteMapping
    public Result<String> removeObject(@Validated @RequestBody RemoveObjectRequest request) {
        this.objectService.removeObject((RemoveObjectArgs)request.build());
        return this.result(true);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664\u591a\u4e2a\u5bf9\u8c61", description="\u6839\u636e\u4f20\u5165\u7684Object\u540d\u79f0\u5220\u9664\u5bf9\u5e94\u7684\u5bf9\u8c61", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u5df2\u4fdd\u5b58\u6570\u636e", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="request", required=true, description="\u5220\u9664\u5bf9\u8c61\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", schema=@Schema(implementation=RemoveObjectsRequest.class))})
    @DeleteMapping(value={"/multi"})
    public Result<List<DeleteErrorResponse>> removeObjects(@Validated @RequestBody RemoveObjectsRequest request) {
        List<DeleteErrorResponse> items = this.objectService.removeObjects((RemoveObjectsArgs)request.build());
        return this.result(items);
    }
}

