/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oss.minio.domain.MultipartUploadCreate;
import cn.herodotus.engine.oss.minio.dto.logic.CompleteMultipartUploadDto;
import cn.herodotus.engine.oss.minio.dto.logic.CreateMultipartUpload;
import cn.herodotus.engine.oss.minio.processor.MultipartUploadProcessor;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.minio.ObjectWriteResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/multipart"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u5206\u7247\u4e0a\u4f20\u63a5\u53e3")})
public class MultipartUploadController
implements Controller {
    private final MultipartUploadProcessor multipartUploadProcessor;

    public MultipartUploadController(MultipartUploadProcessor multipartUploadProcessor) {
        this.multipartUploadProcessor = multipartUploadProcessor;
    }

    @Idempotent
    @Operation(summary="\u521b\u5efa\u5206\u7247\u4e0a\u4f20\u4fe1\u606f", description="\u521b\u5efa\u5206\u7247\u4e0a\u4f20\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="domain", required=true, description="Create Multipart Upload \u8bf7\u6c42\u5b9e\u4f53", schema=@Schema(implementation=CreateMultipartUpload.class))})
    @PostMapping(value={"/create"})
    public Result<MultipartUploadCreate> createMultipartUpload(@Validated @RequestBody CreateMultipartUpload domain) {
        MultipartUploadCreate result = this.multipartUploadProcessor.createMultipartUpload(domain.getBucketName(), domain.getObjectName(), domain.getSize());
        return this.result(result);
    }

    @Idempotent
    @Operation(summary="\u5b8c\u6210\u5206\u7247\u4e0a\u4f20", description="\u5b8c\u6210\u5206\u7247\u4e0a\u4f20\uff0cMinio\u5c06\u4e0a\u4f20\u5b8c\u6210\u7684\u5206\u7247\u4fe1\u606f\u8fdb\u884c\u5408\u5e76", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="bucketName", required=true, description="\u5b58\u50a8\u6876\u540d\u79f0"), @Parameter(name="objectName", required=true, description="\u6587\u4ef6\u540d\u79f0"), @Parameter(name="objectName", required=true, description="\u6587\u4ef6\u540d\u79f0")})
    @PostMapping(value={"/complete"})
    public Result<String> completeMultipartUpload(@Validated @RequestBody CompleteMultipartUploadDto domain) {
        ObjectWriteResponse objectWriteResponse = this.multipartUploadProcessor.completeMultipartUpload(domain.getBucketName(), domain.getObjectName(), domain.getUploadId());
        if (ObjectUtils.isNotEmpty((Object)objectWriteResponse)) {
            return this.result(true);
        }
        return this.result(false);
    }
}

