/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.assistant.core.utils.DateTimeUtils;
import cn.herodotus.engine.oss.core.exception.OssErrorResponseException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssInvalidResponseException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssServerException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.definition.pool.MinioClientObjectPool;
import cn.herodotus.engine.oss.minio.definition.service.BaseMinioService;
import cn.herodotus.engine.oss.minio.domain.response.RetentionResponse;
import io.minio.GetObjectRetentionArgs;
import io.minio.MinioClient;
import io.minio.SetObjectRetentionArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Retention;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ObjectRetentionService
extends BaseMinioService {
    private static final Logger log = LoggerFactory.getLogger(ObjectRetentionService.class);

    public ObjectRetentionService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public void setObjectRetention(SetObjectRetentionArgs setObjectRetentionArgs) {
        String function = "setObjectRetention";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setObjectRetention(setObjectRetentionArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public RetentionResponse getObjectRetention(GetObjectRetentionArgs getObjectRetentionArgs) {
        String function = "getObjectRetention";
        MinioClient minioClient = this.getMinioClient();
        try {
            Retention retention = minioClient.getObjectRetention(getObjectRetentionArgs);
            RetentionResponse retentionResponse = this.toRetentionResponse(retention);
            return retentionResponse;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    private RetentionResponse toRetentionResponse(Retention retention) {
        RetentionResponse retentionResponse = new RetentionResponse();
        if (ObjectUtils.isNotEmpty((Object)retention)) {
            retentionResponse.setMode(retention.mode().name());
            if (ObjectUtils.isNotEmpty((Object)retention.retainUntilDate())) {
                retentionResponse.setRetainUntilDate(DateTimeUtils.zonedDateTimeToString((ZonedDateTime)retention.retainUntilDate()));
            }
        }
        return retentionResponse;
    }
}

