/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.oss.core.exception.OssExecutionException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInterruptedException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.definition.pool.MinioAsyncClient;
import cn.herodotus.engine.oss.minio.definition.pool.MinioAsyncClientObjectPool;
import cn.herodotus.engine.oss.minio.definition.service.BaseMinioAsyncService;
import com.google.common.collect.Multimap;
import io.minio.CreateMultipartUploadResponse;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Part;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MultipartUploadAsyncService
extends BaseMinioAsyncService {
    private static final Logger log = LoggerFactory.getLogger(MultipartUploadAsyncService.class);

    public MultipartUploadAsyncService(MinioAsyncClientObjectPool minioAsyncClientObjectPool) {
        super(minioAsyncClientObjectPool);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String objectName) {
        return this.createMultipartUpload(bucketName, null, objectName);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String region, String objectName) {
        return this.createMultipartUpload(bucketName, region, objectName, null);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String region, String objectName, Multimap<String, String> extraHeaders) {
        return this.createMultipartUpload(bucketName, region, objectName, extraHeaders, null);
    }

    public CreateMultipartUploadResponse createMultipartUpload(String bucketName, String region, String objectName, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) {
        String function = "createMultipartUpload";
        MinioAsyncClient minioAsyncClient = this.getMinioClient();
        try {
            CreateMultipartUploadResponse createMultipartUploadResponse = minioAsyncClient.createMultipartUploadAsync(bucketName, region, objectName, extraHeaders, extraQueryParams).get();
            return createMultipartUploadResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio async catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio async io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close(minioAsyncClient);
        }
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String objectName, String uploadId, Part[] parts) {
        return this.completeMultipartUpload(bucketName, null, objectName, uploadId, parts);
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId) {
        return this.completeMultipartUpload(bucketName, region, objectName, uploadId, null);
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts) {
        return this.completeMultipartUpload(bucketName, region, objectName, uploadId, parts, null);
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts, Multimap<String, String> extraHeaders) {
        return this.completeMultipartUpload(bucketName, region, objectName, uploadId, parts, extraHeaders, null);
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String region, String objectName, String uploadId, Part[] parts, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) {
        String function = "completeMultipartUploadAsync";
        MinioAsyncClient minioAsyncClient = this.getMinioClient();
        try {
            ObjectWriteResponse objectWriteResponse = minioAsyncClient.completeMultipartUploadAsync(bucketName, region, objectName, uploadId, parts, extraHeaders, extraQueryParams).get();
            return objectWriteResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio async catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio async io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close(minioAsyncClient);
        }
    }

    public ListPartsResponse listParts(String bucketName, String objectName, String uploadId) {
        return this.listParts(bucketName, null, objectName, uploadId);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, String uploadId) {
        return this.listParts(bucketName, region, objectName, null, uploadId);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, String uploadId) {
        return this.listParts(bucketName, region, objectName, maxParts, null, uploadId);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId) {
        return this.listParts(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, null);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId, Multimap<String, String> extraHeaders) {
        return this.listParts(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, extraHeaders, null);
    }

    public ListPartsResponse listParts(String bucketName, String region, String objectName, Integer maxParts, Integer partNumberMarker, String uploadId, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) {
        String function = "listParts";
        MinioAsyncClient minioAsyncClient = this.getMinioClient();
        try {
            ListPartsResponse listPartsResponse = minioAsyncClient.listPartsAsync(bucketName, region, objectName, maxParts, partNumberMarker, uploadId, extraHeaders, extraQueryParams).get();
            return listPartsResponse;
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio async catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio async insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio async catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio async internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio async catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio async key invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio async catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio async io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio async catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio async no such algorithm.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio async catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio async xml parser error.");
        }
        catch (ExecutionException e) {
            log.error("[Herodotus] |- Minio async catch ExecutionException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException("Minio async execution error.");
        }
        catch (InterruptedException e) {
            log.error("[Herodotus] |- Minio async catch InterruptedException in [{}].", (Object)function, (Object)e);
            throw new OssInterruptedException("Minio async interrupted error.");
        }
        finally {
            this.close(minioAsyncClient);
        }
    }
}

