/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.oss.core.exception.OssErrorResponseException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssInvalidResponseException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssServerException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.definition.pool.MinioClientObjectPool;
import cn.herodotus.engine.oss.minio.definition.service.BaseMinioService;
import cn.herodotus.engine.oss.minio.service.BucketPolicyService;
import io.minio.DeleteBucketTagsArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.MinioClient;
import io.minio.SetBucketTagsArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Tags;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BucketTagsService
extends BaseMinioService {
    private static final Logger log = LoggerFactory.getLogger(BucketPolicyService.class);

    public BucketTagsService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public void setBucketTags(String bucketName, Tags tags) {
        this.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketName)).tags(tags).build());
    }

    public void setBucketTags(String bucketName, String region, Tags tags) {
        this.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketName)).region(region)).tags(tags).build());
    }

    public void setBucketTags(String bucketName, Map<String, String> tags) {
        this.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketName)).tags(tags).build());
    }

    public void setBucketTags(String bucketName, String region, Map<String, String> tags) {
        this.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketName)).region(region)).tags(tags).build());
    }

    public void setBucketTags(SetBucketTagsArgs setBucketTagsArgs) {
        String function = "setBucketTags";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setBucketTags(setBucketTagsArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public Tags getBucketTags(String bucketName) {
        return this.getBucketTags((GetBucketTagsArgs)((GetBucketTagsArgs.Builder)GetBucketTagsArgs.builder().bucket(bucketName)).build());
    }

    public Tags getBucketTags(String bucketName, String region) {
        return this.getBucketTags((GetBucketTagsArgs)((GetBucketTagsArgs.Builder)((GetBucketTagsArgs.Builder)GetBucketTagsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Tags getBucketTags(GetBucketTagsArgs getBucketTagsArgs) {
        String function = "getBucketTags";
        MinioClient minioClient = this.getMinioClient();
        try {
            Tags tags = minioClient.getBucketTags(getBucketTagsArgs);
            return tags;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in createBucket.", (Throwable)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void deleteBucketTags(String bucketName) {
        this.deleteBucketTags((DeleteBucketTagsArgs)((DeleteBucketTagsArgs.Builder)DeleteBucketTagsArgs.builder().bucket(bucketName)).build());
    }

    public void deleteBucketTags(String bucketName, String region) {
        this.deleteBucketTags((DeleteBucketTagsArgs)((DeleteBucketTagsArgs.Builder)((DeleteBucketTagsArgs.Builder)DeleteBucketTagsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void deleteBucketTags(DeleteBucketTagsArgs deleteBucketTagsArgs) {
        String function = "deleteBucketTags";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.deleteBucketTags(deleteBucketTagsArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }
}

