/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.processor;

import cn.herodotus.engine.oss.minio.domain.MultipartUploadCreate;
import cn.herodotus.engine.oss.minio.service.MultipartUploadAsyncService;
import cn.herodotus.engine.oss.minio.service.PresignedService;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.http.Method;
import io.minio.messages.Part;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MultipartUploadProcessor {
    private final MultipartUploadAsyncService multipartUploadAsyncService;
    private final PresignedService presignedService;

    @Autowired
    public MultipartUploadProcessor(MultipartUploadAsyncService multipartUploadAsyncService, PresignedService presignedService) {
        this.multipartUploadAsyncService = multipartUploadAsyncService;
        this.presignedService = presignedService;
    }

    private String createUploadId(String bucketName, String objectName) {
        CreateMultipartUploadResponse response = this.multipartUploadAsyncService.createMultipartUpload(bucketName, objectName);
        return response.result().uploadId();
    }

    private String createPresignedObjectUrl(String bucketName, String objectName, String uploadId, int partNumber) {
        HashMap<String, String> extraQueryParams = new HashMap<String, String>();
        extraQueryParams.put("partNumber", String.valueOf(partNumber));
        extraQueryParams.put("uploadId", uploadId);
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(objectName)).method(Method.PUT).extraQueryParams(extraQueryParams)).expiry(1, TimeUnit.HOURS).build();
        return this.presignedService.getPresignedObjectUrl(args);
    }

    private Part[] listParts(String bucketName, String objectName, String uploadId) {
        ListPartsResponse response = this.multipartUploadAsyncService.listParts(bucketName, objectName, uploadId);
        List partList = response.result().partList();
        Part[] parts = new Part[partList.size()];
        return partList.toArray(parts);
    }

    public MultipartUploadCreate createMultipartUpload(String bucketName, String objectName, int chunkSize) {
        String uploadId = this.createUploadId(bucketName, objectName);
        MultipartUploadCreate entity = new MultipartUploadCreate(uploadId);
        for (int i = 0; i < chunkSize; ++i) {
            String uploadUrl = this.createPresignedObjectUrl(bucketName, objectName, uploadId, i);
            entity.appendChunk(uploadUrl);
        }
        return entity;
    }

    public ObjectWriteResponse completeMultipartUpload(String bucketName, String objectName, String uploadId) {
        Object[] parts = this.listParts(bucketName, objectName, uploadId);
        if (ArrayUtils.isNotEmpty((Object[])parts)) {
            return this.multipartUploadAsyncService.completeMultipartUpload(bucketName, objectName, uploadId, (Part[])parts);
        }
        return null;
    }
}

