/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.oss.core.exception.OssErrorResponseException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssInvalidResponseException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssServerException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.definition.service.BaseMinioService;
import io.minio.GetBucketVersioningArgs;
import io.minio.MinioClient;
import io.minio.SetBucketVersioningArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.VersioningConfiguration;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BucketVersioningService
extends BaseMinioService {
    private static final Logger log = LoggerFactory.getLogger(BucketVersioningService.class);

    public void enabledBucketVersioning(String bucketName) {
        this.setBucketVersioning(bucketName, VersioningConfiguration.Status.ENABLED);
    }

    public void enabledBucketVersioning(String bucketName, String region) {
        this.setBucketVersioning(bucketName, region, VersioningConfiguration.Status.ENABLED);
    }

    public void suspendedBucketVersioning(String bucketName) {
        this.setBucketVersioning(bucketName, VersioningConfiguration.Status.SUSPENDED);
    }

    public void suspendedBucketVersioning(String bucketName, String region) {
        this.setBucketVersioning(bucketName, region, VersioningConfiguration.Status.SUSPENDED);
    }

    public void offBucketVersioning(String bucketName) {
        this.setBucketVersioning(bucketName, VersioningConfiguration.Status.OFF);
    }

    public void offBucketVersioning(String bucketName, String region) {
        this.setBucketVersioning(bucketName, region, VersioningConfiguration.Status.OFF);
    }

    public void setBucketVersioning(String bucketName, VersioningConfiguration.Status status) {
        this.setBucketVersioning(bucketName, status, null);
    }

    public void setBucketVersioning(String bucketName, VersioningConfiguration.Status status, Boolean mfaDelete) {
        this.setBucketVersioning(bucketName, new VersioningConfiguration(status, mfaDelete));
    }

    public void setBucketVersioning(String bucketName, VersioningConfiguration versioningConfiguration) {
        this.setBucketVersioning((SetBucketVersioningArgs)((SetBucketVersioningArgs.Builder)SetBucketVersioningArgs.builder().bucket(bucketName)).config(versioningConfiguration).build());
    }

    public void setBucketVersioning(String bucketName, String region, VersioningConfiguration.Status status) {
        this.setBucketVersioning(bucketName, region, status, null);
    }

    public void setBucketVersioning(String bucketName, String region, VersioningConfiguration.Status status, Boolean mfaDelete) {
        this.setBucketVersioning(bucketName, region, new VersioningConfiguration(status, mfaDelete));
    }

    public void setBucketVersioning(String bucketName, String region, VersioningConfiguration versioningConfiguration) {
        this.setBucketVersioning((SetBucketVersioningArgs)((SetBucketVersioningArgs.Builder)((SetBucketVersioningArgs.Builder)SetBucketVersioningArgs.builder().bucket(bucketName)).region(region)).config(versioningConfiguration).build());
    }

    public void setBucketVersioning(SetBucketVersioningArgs setBucketVersioningArgs) {
        String function = "setBucketVersioning";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setBucketVersioning(setBucketVersioningArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public VersioningConfiguration getBucketVersioning(String bucketName) {
        return this.getBucketVersioning((GetBucketVersioningArgs)((GetBucketVersioningArgs.Builder)GetBucketVersioningArgs.builder().bucket(bucketName)).build());
    }

    public VersioningConfiguration getBucketVersioning(String bucketName, String region) {
        return this.getBucketVersioning((GetBucketVersioningArgs)((GetBucketVersioningArgs.Builder)((GetBucketVersioningArgs.Builder)GetBucketVersioningArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public VersioningConfiguration getBucketVersioning(GetBucketVersioningArgs getBucketVersioningArgs) {
        String function = "getBucketVersioning";
        MinioClient minioClient = this.getMinioClient();
        try {
            VersioningConfiguration versioningConfiguration = minioClient.getBucketVersioning(getBucketVersioningArgs);
            return versioningConfiguration;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }
}

