/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.dto.api.base;

import cn.herodotus.engine.assistant.core.utils.DateTimeUtils;
import cn.herodotus.engine.oss.minio.definition.dto.api.ObjectArgsDto;
import cn.herodotus.engine.oss.minio.dto.api.base.RetentionDto;
import io.minio.ObjectWriteArgs;
import io.minio.messages.Retention;
import io.minio.messages.RetentionMode;
import java.time.ZonedDateTime;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class ObjectWriteArgsDto<B extends ObjectWriteArgs.Builder<B, A>, A extends ObjectWriteArgs>
extends ObjectArgsDto<B, A> {
    private Map<String, String> headers;
    private Map<String, String> userMetadata;
    private Map<String, String> tags;
    private RetentionDto retention;
    private Boolean legalHold;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RetentionDto getRetention() {
        return this.retention;
    }

    public void setRetention(RetentionDto retention) {
        this.retention = retention;
    }

    public Boolean getLegalHold() {
        return this.legalHold;
    }

    public void setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
    }

    @Override
    protected void prepare(B builder) {
        if (MapUtils.isNotEmpty(this.getHeaders())) {
            builder.headers(this.getHeaders());
        }
        if (MapUtils.isNotEmpty(this.getUserMetadata())) {
            builder.headers(this.getUserMetadata());
        }
        if (MapUtils.isNotEmpty(this.getTags())) {
            builder.headers(this.getTags());
        }
        if (ObjectUtils.isNotEmpty((Object)((Object)this.getRetention()))) {
            RetentionMode mode = RetentionMode.valueOf((String)this.getRetention().getMode());
            ZonedDateTime retainUntilDate = DateTimeUtils.stringToZonedDateTime((String)this.getRetention().getRetainUntilDate());
            builder.retention(new Retention(mode, retainUntilDate));
        }
        super.prepare(builder);
    }

    @Override
    public A build() {
        ObjectWriteArgs.Builder builder = (ObjectWriteArgs.Builder)this.getBuilder();
        this.prepare(builder);
        return (A)((ObjectWriteArgs)builder.build());
    }
}

