/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.configuration;

import cn.herodotus.engine.oss.minio.annotation.ConditionalOnMinioEnabled;
import cn.herodotus.engine.oss.minio.core.MinioAsyncClientObjectPool;
import cn.herodotus.engine.oss.minio.core.MinioClientObjectPool;
import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMinioEnabled
@EnableConfigurationProperties(value={MinioProperties.class})
public class MinioConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MinioConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- SDK [Oss Minio] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioClientObjectPool minioClientPool(MinioProperties minioProperties) {
        MinioClientObjectPool minioClientObjectPool = new MinioClientObjectPool(minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Client Pool] Auto Configure.");
        return minioClientObjectPool;
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioAsyncClientObjectPool minioAsyncClientPool(MinioProperties minioProperties) {
        MinioAsyncClientObjectPool minioAsyncClientObjectPool = new MinioAsyncClientObjectPool(minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Async Client Pool] Auto Configure.");
        return minioAsyncClientObjectPool;
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackages={"cn.herodotus.engine.oss.minio.service", "cn.herodotus.engine.oss.minio.processor", "cn.herodotus.engine.oss.minio.controller"})
    static class MinioLogicConfiguration {
        MinioLogicConfiguration() {
        }

        @PostConstruct
        public void init() {
            log.debug("[Herodotus] |- SDK [Oss Minio Logic] Auto Configure.");
        }
    }
}

