/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.domain;

import com.google.common.base.MoreObjects;
import io.minio.messages.Item;
import io.minio.messages.Owner;
import java.util.Date;

public class MinioItem {
    private String objectName;
    private Date lastModified;
    private String etag;
    private long size;
    private String storageClass;
    private Owner owner;
    private String type;

    public MinioItem(String objectName, Date lastModified, String etag, long size, String storageClass, Owner owner, String type) {
        this.objectName = objectName;
        this.lastModified = lastModified;
        this.etag = etag;
        this.size = size;
        this.storageClass = storageClass;
        this.owner = owner;
        this.type = type;
    }

    public MinioItem(Item item) {
        this.objectName = item.objectName();
        this.lastModified = Date.from(item.lastModified().toInstant());
        this.etag = item.etag();
        this.size = item.size();
        this.storageClass = item.storageClass();
        this.owner = item.owner();
        this.type = item.isDir() ? "directory" : "file";
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("objectName", (Object)this.objectName).add("lastModified", (Object)this.lastModified).add("etag", (Object)this.etag).add("size", this.size).add("storageClass", (Object)this.storageClass).add("owner", (Object)this.owner).add("type", (Object)this.type).toString();
    }
}

