/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oss.minio.domain.MinioBucket;
import cn.herodotus.engine.oss.minio.dto.api.bucket.MakeBucketArgsDto;
import cn.herodotus.engine.oss.minio.dto.api.bucket.RemoveBucketArgsDto;
import cn.herodotus.engine.oss.minio.dto.logic.CreateBucketDto;
import cn.herodotus.engine.oss.minio.service.BucketService;
import cn.herodotus.engine.protect.core.annotation.AccessLimited;
import cn.herodotus.engine.protect.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.minio.MakeBucketArgs;
import io.minio.RemoveBucketArgs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss/minio/bucket"})
@Tags(value={@Tag(name="\u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u7ba1\u7406\u63a5\u53e3"), @Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8Bucket\u7ba1\u7406\u63a5\u53e3")})
public class BucketController
implements Controller {
    private final BucketService bucketService;

    @Autowired
    public BucketController(BucketService bucketService) {
        this.bucketService = bucketService;
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u5168\u90e8Bucket\u63a5\u53e3", description="\u83b7\u53d6\u5168\u90e8Bucket\u63a5\u53e3")
    @GetMapping(value={"/list"})
    public Result<List<MinioBucket>> findAll() {
        List<MinioBucket> buckets = this.bucketService.listBuckets();
        return this.result(buckets);
    }

    @Idempotent
    @Operation(summary="\u521b\u5efaBucket\u63a5\u53e3", description="\u521b\u5efaBucket\u63a5\u53e3\uff0c\u8be5\u63a5\u53e3\u4ec5\u662f\u521b\u5efa\uff0c\u4e0d\u5305\u542b\u662f\u5426\u5df2\u5b58\u5728\u68c0\u67e5", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="domain", required=true, description="Make Bucket \u8bf7\u6c42\u5b9e\u4f53", schema=@Schema(implementation=MakeBucketArgsDto.class))})
    @PostMapping
    public Result<String> make(@Validated @RequestBody MakeBucketArgsDto domain) {
        this.bucketService.makeBucket((MakeBucketArgs)domain.build());
        return this.result(true);
    }

    @Idempotent
    @Operation(summary="\u521b\u5efaBucket\u63a5\u53e3", description="\u521b\u5efaBucket\u63a5\u53e3\uff0c\u8be5\u63a5\u53e3\u5305\u542bBucket\u662f\u5426\u5df2\u5b58\u5728\u68c0\u67e5", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u662f\u5426\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="domain", required=true, description="Make Bucket \u8bf7\u6c42\u5b9e\u4f53", schema=@Schema(implementation=CreateBucketDto.class))})
    @PostMapping(value={"/create"})
    public Result<String> create(@Validated @RequestBody CreateBucketDto domain) {
        if (StringUtils.isNotBlank((CharSequence)domain.getRegion())) {
            this.bucketService.createBucket(domain.getBucketName(), domain.getRegion());
        } else {
            this.bucketService.createBucket(domain.getBucketName());
        }
        return this.result(true);
    }

    @Idempotent
    @Operation(summary="\u5220\u9664Bucket\u63a5\u53e3", description="\u6839\u636eBucket \u540d\u79f0\u5220\u9664\u6570\u636e\uff0c\u53ef\u6307\u5b9a Region", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="domain", required=true, description="Remote Bucket \u8bf7\u6c42\u5b9e\u4f53", schema=@Schema(implementation=RemoveBucketArgsDto.class))})
    @DeleteMapping
    public Result<String> delete(@Validated @RequestBody RemoveBucketArgsDto domain) {
        this.bucketService.removeBucket((RemoveBucketArgs)domain.build());
        return this.result(true);
    }
}

