/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.core.exception.OssClientPoolErrorException;
import cn.herodotus.engine.oss.minio.core.MinioAsyncClient;
import cn.herodotus.engine.oss.minio.core.MinioAsyncClientPooledObjectFactory;
import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioAsyncClientObjectPool {
    private static final Logger log = LoggerFactory.getLogger(MinioAsyncClientObjectPool.class);
    private final GenericObjectPool<MinioAsyncClient> minioAsyncClientPool;

    public MinioAsyncClientObjectPool(MinioProperties minioProperties) {
        MinioAsyncClientPooledObjectFactory factory = new MinioAsyncClientPooledObjectFactory(minioProperties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(minioProperties.getPool().getMaxTotal().intValue());
        config.setMaxIdle(minioProperties.getPool().getMaxIdle().intValue());
        config.setMinIdle(minioProperties.getPool().getMinIdle().intValue());
        config.setMaxWait(minioProperties.getPool().getMaxWait());
        config.setMinEvictableIdleTime(minioProperties.getPool().getMinEvictableIdleTime());
        config.setSoftMinEvictableIdleTime(minioProperties.getPool().getSoftMinEvictableIdleTime());
        config.setLifo(minioProperties.getPool().getLifo().booleanValue());
        config.setBlockWhenExhausted(minioProperties.getPool().getBlockWhenExhausted().booleanValue());
        this.minioAsyncClientPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public MinioAsyncClient getMinioClient() throws OssClientPoolErrorException {
        try {
            MinioAsyncClient minioAsyncClient = (MinioAsyncClient)((Object)this.minioAsyncClientPool.borrowObject());
            log.debug("[Herodotus] |- Fetch minio async client from object pool.");
            return minioAsyncClient;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch minio client from pool.");
            throw new OssClientPoolErrorException("Can not fetch minio async client from pool.");
        }
    }

    public void close(MinioAsyncClient minioAsyncClient) {
        if (ObjectUtils.isNotEmpty((Object)((Object)minioAsyncClient))) {
            this.minioAsyncClientPool.returnObject((Object)minioAsyncClient);
        }
    }
}

