/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.core.exception.OssClientPoolErrorException;
import cn.herodotus.engine.oss.minio.core.MinioClientPooledObjectFactory;
import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import io.minio.MinioClient;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioClientObjectPool {
    private static final Logger log = LoggerFactory.getLogger(MinioClientObjectPool.class);
    private final GenericObjectPool<MinioClient> minioClientPool;

    public MinioClientObjectPool(MinioProperties minioProperties) {
        MinioClientPooledObjectFactory factory = new MinioClientPooledObjectFactory(minioProperties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(minioProperties.getPool().getMaxTotal().intValue());
        config.setMaxIdle(minioProperties.getPool().getMaxIdle().intValue());
        config.setMinIdle(minioProperties.getPool().getMinIdle().intValue());
        config.setMaxWait(minioProperties.getPool().getMaxWait());
        config.setMinEvictableIdleTime(minioProperties.getPool().getMinEvictableIdleTime());
        config.setSoftMinEvictableIdleTime(minioProperties.getPool().getSoftMinEvictableIdleTime());
        config.setLifo(minioProperties.getPool().getLifo().booleanValue());
        config.setBlockWhenExhausted(minioProperties.getPool().getBlockWhenExhausted().booleanValue());
        this.minioClientPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public MinioClient getMinioClient() throws OssClientPoolErrorException {
        try {
            MinioClient minioClient = (MinioClient)this.minioClientPool.borrowObject();
            log.debug("[Herodotus] |- Fetch minio client from object pool.");
            return minioClient;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch minio client from pool.");
            throw new OssClientPoolErrorException("Can not fetch minio client from pool.");
        }
    }

    public void close(MinioClient minioClient) {
        if (ObjectUtils.isNotEmpty((Object)minioClient)) {
            this.minioClientPool.returnObject((Object)minioClient);
        }
    }
}

