/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.oss.core.exception.OssErrorResponseException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssInvalidResponseException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssServerException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.core.MinioClientObjectPool;
import cn.herodotus.engine.oss.minio.core.MinioTemplate;
import io.minio.DeleteObjectTagsArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.MinioClient;
import io.minio.SetObjectTagsArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Tags;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObjectTagsService
extends MinioTemplate {
    private static final Logger log = LoggerFactory.getLogger(ObjectTagsService.class);

    @Autowired
    public ObjectTagsService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public void setObjectTags(String bucketName, String objectName, Map<String, String> tags) {
        this.setObjectTags((SetObjectTagsArgs)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)SetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).tags(tags).build());
    }

    public void setObjectTags(String bucketName, String objectName, String versionId, Map<String, String> tags) {
        this.setObjectTags((SetObjectTagsArgs)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)SetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).tags(tags).build());
    }

    public void setObjectTags(String bucketName, String objectName, String region, String versionId, Map<String, String> tags) {
        this.setObjectTags((SetObjectTagsArgs)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)SetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).region(region)).versionId(versionId)).tags(tags).build());
    }

    public void setObjectTags(SetObjectTagsArgs setObjectTagsArgs) {
        String function = "setObjectTags";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.setObjectTags(setObjectTagsArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public Tags getObjectTags(String bucketName, String objectName) {
        return this.getObjectTags((GetObjectTagsArgs)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)GetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public Tags getObjectTags(String bucketName, String objectName, String versionId) {
        return this.getObjectTags((GetObjectTagsArgs)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)GetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).build());
    }

    public Tags getObjectTags(String bucketName, String objectName, String region, String versionId) {
        return this.getObjectTags((GetObjectTagsArgs)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)GetObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).region(region)).versionId(versionId)).build());
    }

    public Tags getObjectTags(GetObjectTagsArgs getObjectTagsArgs) {
        String function = "getObjectTags";
        MinioClient minioClient = this.getMinioClient();
        try {
            Tags tags = minioClient.getObjectTags(getObjectTagsArgs);
            return tags;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void deleteObjectTags(String bucketName, String objectName) {
        this.deleteObjectTags((DeleteObjectTagsArgs)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)DeleteObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public void deleteObjectTags(String bucketName, String objectName, String versionId) {
        this.deleteObjectTags((DeleteObjectTagsArgs)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)DeleteObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).versionId(versionId)).build());
    }

    public void deleteObjectTags(String bucketName, String objectName, String region, String versionId) {
        this.deleteObjectTags((DeleteObjectTagsArgs)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)DeleteObjectTagsArgs.builder().bucket(bucketName)).object(objectName)).region(region)).versionId(versionId)).build());
    }

    public void deleteObjectTags(DeleteObjectTagsArgs deleteObjectTagsArgs) {
        String function = "deleteObjectTags";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.deleteObjectTags(deleteObjectTagsArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }
}

