/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.service;

import cn.herodotus.engine.oss.core.exception.OssErrorResponseException;
import cn.herodotus.engine.oss.core.exception.OssIOException;
import cn.herodotus.engine.oss.core.exception.OssInsufficientDataException;
import cn.herodotus.engine.oss.core.exception.OssInternalException;
import cn.herodotus.engine.oss.core.exception.OssInvalidKeyException;
import cn.herodotus.engine.oss.core.exception.OssInvalidResponseException;
import cn.herodotus.engine.oss.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.engine.oss.core.exception.OssServerException;
import cn.herodotus.engine.oss.core.exception.OssXmlParserException;
import cn.herodotus.engine.oss.minio.core.MinioClientObjectPool;
import cn.herodotus.engine.oss.minio.core.MinioTemplate;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveBucketArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Bucket;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BucketService
extends MinioTemplate {
    private static final Logger log = LoggerFactory.getLogger(BucketService.class);

    @Autowired
    public BucketService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public boolean bucketExists(String bucketName) {
        return this.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    public boolean bucketExists(String bucketName, String region) {
        return this.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public boolean bucketExists(BucketExistsArgs bucketExistsArgs) {
        String function = "bucketExists";
        MinioClient minioClient = this.getMinioClient();
        try {
            boolean bl = minioClient.bucketExists(bucketExistsArgs);
            return bl;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void makeBucket(String bucketName) {
        this.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
    }

    public void makeBucket(String bucketName, String region) {
        this.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).bucket(region)).build());
    }

    public void makeBucket(MakeBucketArgs makeBucketArgs) {
        String function = "makeBucket";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.makeBucket(makeBucketArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void createBucket(String bucketName) {
        this.createBucket((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build(), (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
    }

    public void createBucket(String bucketName, String region) {
        this.createBucket((BucketExistsArgs)((BucketExistsArgs.Builder)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).region(region)).build(), (MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void createBucket(BucketExistsArgs bucketExistsArgs, MakeBucketArgs makeBucketArgs) {
        if (!this.bucketExists(bucketExistsArgs)) {
            this.makeBucket(makeBucketArgs);
        }
    }

    public List<Bucket> listBuckets() {
        String function = "listBuckets";
        MinioClient minioClient = this.getMinioClient();
        try {
            List list = minioClient.listBuckets();
            return list;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void removeBucket(String bucketName) {
        this.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public void removeBucket(String bucketName, String region) {
        this.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void removeBucket(RemoveBucketArgs removeBucketArgs) {
        String function = "removeBucket";
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.removeBucket(removeBucketArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            throw new OssIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public Optional<Bucket> findBucket(String bucketName) {
        List<Bucket> buckets = this.listBuckets();
        if (CollectionUtils.isNotEmpty(buckets)) {
            return buckets.stream().filter(b -> b.name().equals(bucketName)).findFirst();
        }
        return Optional.empty();
    }
}

