/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.core.exception.OssClientPoolErrorException;
import cn.herodotus.engine.oss.minio.core.MinioClientObjectPool;
import io.minio.MinioClient;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinioTemplate {
    private static final Logger log = LoggerFactory.getLogger(MinioTemplate.class);
    private final MinioClientObjectPool minioClientObjectPool;

    public MinioTemplate(MinioClientObjectPool minioClientObjectPool) {
        this.minioClientObjectPool = minioClientObjectPool;
    }

    public MinioClient getMinioClient() throws OssClientPoolErrorException {
        try {
            MinioClient minioClient = (MinioClient)this.minioClientObjectPool.getMinioClientPool().borrowObject();
            log.debug("[Herodotus] |- Fetch minio client from object pool.");
            return minioClient;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch minio client from pool.");
            throw new OssClientPoolErrorException("Can not fetch minio client from pool.");
        }
    }

    protected void close(MinioClient minioClient) {
        if (ObjectUtils.isNotEmpty((Object)minioClient)) {
            this.minioClientObjectPool.getMinioClientPool().returnObject((Object)minioClient);
        }
    }
}

