/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import io.minio.MinioClient;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class MinioClientObjectPool {
    private final GenericObjectPool<MinioClient> minioClientPool;

    public MinioClientObjectPool(MinioProperties minioProperties) {
        MinioClientPooledObjectFactory factory = new MinioClientPooledObjectFactory(minioProperties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(minioProperties.getPool().getMaxTotal().intValue());
        config.setMaxIdle(minioProperties.getPool().getMaxIdle().intValue());
        config.setMinIdle(minioProperties.getPool().getMinIdle().intValue());
        config.setMaxWait(minioProperties.getPool().getMaxWait());
        config.setMinEvictableIdleTime(minioProperties.getPool().getMinEvictableIdleTime());
        config.setSoftMinEvictableIdleTime(minioProperties.getPool().getSoftMinEvictableIdleTime());
        config.setLifo(minioProperties.getPool().getLifo().booleanValue());
        config.setBlockWhenExhausted(minioProperties.getPool().getBlockWhenExhausted().booleanValue());
        this.minioClientPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public GenericObjectPool<MinioClient> getMinioClientPool() {
        return this.minioClientPool;
    }

    public static class MinioClientPooledObjectFactory
    extends BasePooledObjectFactory<MinioClient> {
        private final MinioProperties minioProperties;

        public MinioClientPooledObjectFactory(MinioProperties minioProperties) {
            this.minioProperties = minioProperties;
        }

        public MinioClient create() throws Exception {
            return MinioClient.builder().endpoint(this.minioProperties.getEndpoint()).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).build();
        }

        public PooledObject<MinioClient> wrap(MinioClient minioClient) {
            return new DefaultPooledObject((Object)minioClient);
        }
    }
}

