/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.minio.core.MinioClientPool;
import cn.herodotus.engine.oss.minio.domain.MinioItem;
import cn.herodotus.engine.oss.minio.exception.MinioClientPoolErrorExeption;
import cn.herodotus.engine.oss.minio.exception.MinioErrorResponseException;
import cn.herodotus.engine.oss.minio.exception.MinioIOException;
import cn.herodotus.engine.oss.minio.exception.MinioInsufficientDataException;
import cn.herodotus.engine.oss.minio.exception.MinioInternalException;
import cn.herodotus.engine.oss.minio.exception.MinioInvalidKeyException;
import cn.herodotus.engine.oss.minio.exception.MinioInvalidResponseException;
import cn.herodotus.engine.oss.minio.exception.MinioNoSuchAlgorithmException;
import cn.herodotus.engine.oss.minio.exception.MinioServerException;
import cn.herodotus.engine.oss.minio.exception.MinioXmlParserException;
import io.minio.BucketExistsArgs;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioTemplate {
    private static final Logger log = LoggerFactory.getLogger(MinioTemplate.class);
    private final MinioClientPool minioClientPool;

    public MinioTemplate(MinioClientPool minioClientPool) {
        this.minioClientPool = minioClientPool;
    }

    private void close(MinioClient minioClient) {
        if (ObjectUtils.isNotEmpty((Object)minioClient)) {
            this.minioClientPool.getMinioClientPool().returnObject((Object)minioClient);
        }
    }

    public MinioClient getMinioClient() throws MinioClientPoolErrorExeption {
        try {
            MinioClient minioClient = (MinioClient)this.minioClientPool.getMinioClientPool().borrowObject();
            log.debug("[Herodotus] |- Fetch minio client from connetion pool.");
            return minioClient;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch minio client from pool.");
            throw new MinioClientPoolErrorExeption("Can not fetch minio client from pool.");
        }
    }

    public void createBucket(String bucketName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
                log.debug("[Herodotus] |- Minio create Bucket [{}].", (Object)bucketName);
            }
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in createBucket.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in createBucket.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in createBucket.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in createBucket.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in createBucket.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in createBucket.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in createBucket.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in createBucket.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in createBucket.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public List<Bucket> getAllBuckets() {
        MinioClient minioClient = this.getMinioClient();
        try {
            List list = minioClient.listBuckets();
            return list;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in getAllBuckets.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in getAllBuckets.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in getAllBuckets.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in getAllBuckets.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in getAllBuckets.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in getAllBuckets.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getAllBuckets.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in getAllBuckets.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in getAllBuckets.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public Optional<Bucket> getBucket(String bucketName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            Optional<Bucket> optional = minioClient.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst();
            return optional;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in getBucket.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in getBucket.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in getBucket.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in getBucket.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in getBucket.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in getBucket.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getBucket.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in getBucket.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in getBucket.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void removeBucket(String bucketName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in removeBucket.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in removeBucket.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in removeBucket.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in removeBucket.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in removeBucket.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in removeBucket.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in removeBucket.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in removeBucket.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in removeBucket.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MinioItem> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        MinioClient minioClient = this.getMinioClient();
        try {
            ArrayList<MinioItem> objectList = new ArrayList<MinioItem>();
            Iterable objectsIterator = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(recursive).build());
            objectsIterator.forEach(i -> {
                try {
                    objectList.add(new MinioItem((Item)i.get()));
                }
                catch (ErrorResponseException e) {
                    log.error("[Herodotus] |- Minio cache ErrorResponseException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioErrorResponseException("Minio response error.");
                }
                catch (InsufficientDataException e) {
                    log.error("[Herodotus] |- Minio cache InsufficientDataException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioInsufficientDataException("Minio insufficient data error.");
                }
                catch (InternalException e) {
                    log.error("[Herodotus] |- Minio cache InternalException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioInternalException("Minio internal error.");
                }
                catch (InvalidKeyException e) {
                    log.error("[Herodotus] |- Minio cache InvalidKeyException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioInvalidKeyException("Minio key invalid.");
                }
                catch (InvalidResponseException e) {
                    log.error("[Herodotus] |- Minio cache InvalidResponseException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioInvalidResponseException("Minio response invalid.");
                }
                catch (IOException e) {
                    log.error("[Herodotus] |- Minio cache IOException in removeBucket.", (Throwable)e);
                    throw new MinioIOException("Minio io error.");
                }
                catch (NoSuchAlgorithmException e) {
                    log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
                }
                catch (ServerException e) {
                    log.error("[Herodotus] |- Minio cache ServerException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioServerException("Minio server error.");
                }
                catch (XmlParserException e) {
                    log.error("[Herodotus] |- Minio cache XmlParserException in getAllObjectsByPrefix.", (Throwable)e);
                    throw new MinioXmlParserException("Minio xml parser error.");
                }
            });
            ArrayList<MinioItem> arrayList = objectList;
            return arrayList;
        }
        finally {
            this.close(minioClient);
        }
    }

    private int calculate(Duration expires) {
        long data = expires.toMillis() / 1000L;
        return (int)data;
    }

    public String getObjectURL(String bucketName, String objectName, Duration expires) {
        MinioClient minioClient = this.getMinioClient();
        try {
            String string = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(objectName)).expiry(this.calculate(expires)).build());
            return string;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in getObjectURL.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in getObjectURL.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in getObjectURL.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in getObjectURL.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in getObjectURL.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in getObjectURL.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getObjectURL.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in getObjectURL.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in getObjectURL.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public String getObjectURL(String bucketName, String objectName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            String string = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucketName)).object(objectName)).build());
            return string;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in getObjectURL.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in getObjectURL.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in getObjectURL.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in getObjectURL.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in getObjectURL.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in getObjectURL.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getObjectURL.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in getObjectURL.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in getObjectURL.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void putFile(String bucketName, String fileName, InputStream stream) {
        this.putFile(bucketName, fileName, stream, "application/octet-stream");
    }

    public void putFile(String bucketName, String fileName, InputStream stream, String contentType) {
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(stream, (long)stream.available(), -1L).contentType(contentType).build());
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in putFile.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in putFile.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in putFile.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in putFile.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in putFile.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in putFile.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in putFile.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in putFile.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in putFile.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contentType) {
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, size, -1L).contentType(contentType).build());
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in putObject.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in putObject.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in putObject.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in putObject.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in putObject.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in putObject.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in putObject.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in putObject.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in putObject.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public InputStream getObject(String bucketName, String objectName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            GetObjectResponse getObjectResponse = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            return getObjectResponse;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in getObject.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in getObject.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in getObject.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in getObject.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in getObject.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in getObject.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getObject.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in getObject.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in getObject.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public StatObjectResponse getObjectInfo(String bucketName, String objectName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            StatObjectResponse statObjectResponse = minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            return statObjectResponse;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in getObjectInfo.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in getObjectInfo.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in getObjectInfo.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in getObjectInfo.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in getObjectInfo.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in getObjectInfo.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in getObjectInfo.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in getObjectInfo.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in getObjectInfo.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void removeObject(String bucketName, String objectName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in removeObject.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in removeObject.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in removeObject.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in removeObject.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in removeObject.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in removeObject.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in removeObject.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in removeObject.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in removeObject.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }

    public void downloadObject(String bucketName, String objectName, String fileName) {
        MinioClient minioClient = this.getMinioClient();
        try {
            minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).build());
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio cache ErrorResponseException in downloadObject.", (Throwable)e);
            throw new MinioErrorResponseException("Minio response error.");
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio cache InsufficientDataException in downloadObject.", (Throwable)e);
            throw new MinioInsufficientDataException("Minio insufficient data error.");
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio cache InternalException in downloadObject.", (Throwable)e);
            throw new MinioInternalException("Minio internal error.");
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio cache InvalidKeyException in downloadObject.", (Throwable)e);
            throw new MinioInvalidKeyException("Minio key invalid.");
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio cache InvalidResponseException in downloadObject.", (Throwable)e);
            throw new MinioInvalidResponseException("Minio response invalid.");
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio cache IOException in downloadObject.", (Throwable)e);
            throw new MinioIOException("Minio io error.");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio cache NoSuchAlgorithmException in downloadObject.", (Throwable)e);
            throw new MinioNoSuchAlgorithmException("Minio no such algorithm.");
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio cache ServerException in downloadObject.", (Throwable)e);
            throw new MinioServerException("Minio server error.");
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio cache XmlParserException in downloadObject.", (Throwable)e);
            throw new MinioXmlParserException("Minio xml parser error.");
        }
        finally {
            this.close(minioClient);
        }
    }
}

