/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.minio.core.MinioTemplate;
import cn.herodotus.engine.oss.minio.domain.MinioObject;
import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import cn.hutool.core.util.IdUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MinioManager {
    private static final Logger log = LoggerFactory.getLogger(MinioManager.class);
    private static Map<String, String> contentTypeMap = new HashMap<String, String>();
    private MinioTemplate minioTemplate;
    private MinioProperties minioProperties;

    public MinioManager(MinioTemplate minioTemplate, MinioProperties minioProperties) {
        this.minioTemplate = minioTemplate;
        this.minioProperties = minioProperties;
    }

    private String getFileName(String fileName, String fileSuffix) {
        return fileSuffix.concat(File.separator).concat(LocalDate.now().format(DateTimeFormatter.ofPattern(this.minioProperties.getTimestampFormat()))).concat(File.separator).concat(fileName);
    }

    private String getBucketName() {
        String bucketName = this.minioProperties.getBucketNamePrefix();
        this.minioTemplate.createBucket(bucketName);
        return bucketName;
    }

    private String getSuffix(String fileName) {
        return StringUtils.substringAfterLast((String)fileName, (String)".");
    }

    private MinioObject putMultipartFile(MultipartFile multipartFile, String fileName) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            String fileSuffix = this.getSuffix(fileName);
            String bucketName = this.getBucketName();
            fileName = this.getFileName(fileName, fileSuffix);
            this.minioTemplate.putFile(bucketName, fileName, multipartFile.getInputStream(), multipartFile.getContentType());
            return new MinioObject(bucketName, fileName, new Date(), multipartFile.getInputStream().available(), null, multipartFile.getContentType());
        }
        log.error("[Herodotus] |- Argument fileName is blank in uploadMultipartFile.");
        throw new IllegalArgumentException("Argument is illegal.");
    }

    public MinioObject uploadFile(MultipartFile multipartFile, String fileName) throws IOException {
        return this.putMultipartFile(multipartFile, fileName);
    }

    public MinioObject uploadFile(MultipartFile multipartFile) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        return this.putMultipartFile(multipartFile, fileName);
    }

    private MinioObject putFile(InputStream stream, String fileName) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            String fileSuffix = this.getSuffix(fileName);
            String bucketName = this.getBucketName();
            fileName = this.getFileName(fileName, fileSuffix);
            this.minioTemplate.putFile(bucketName, fileName, stream);
            return new MinioObject(bucketName, fileName, new Date(), stream.available(), null, null);
        }
        log.error("[Herodotus] |- Argument fileName is blank in putFile.");
        throw new IllegalArgumentException("Argument is illegal.");
    }

    private MinioObject putFile(File file, String fileName) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        return this.putFile(stream, fileName);
    }

    public MinioObject uploadFile(File file, String fileName) throws IOException {
        return this.putFile(file, fileName);
    }

    public MinioObject uploadFile(File file) throws IOException {
        String fileName = file.getName();
        return this.putFile(file, fileName);
    }

    public MinioObject uploadFile(InputStream stream, String fileName) throws IOException {
        return this.putFile(stream, fileName);
    }

    public String getFileUrl(String bucketName, String fileName, Duration expires) {
        if (StringUtils.isNotBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)fileName) && expires != Duration.ZERO) {
            return this.minioTemplate.getObjectURL(bucketName, fileName, expires);
        }
        log.error("[Herodotus] |- Argument bucketName or fileName is blank in getFileUrl.");
        throw new IllegalArgumentException("Argument is illegal.");
    }

    public String getFileUrl(String bucketName, String fileName) {
        return this.getFileUrl(bucketName, fileName, Duration.ofDays(3L));
    }

    public InputStream getFileInputStream(String bucketName, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)fileName)) {
            return this.minioTemplate.getObject(bucketName, fileName);
        }
        log.error("[Herodotus] |- Argument bucketName or fileName is blank in getFileInputStream.");
        throw new IllegalArgumentException("Argument is illegal.");
    }

    public void removeFile(String bucketName, String fileName) {
        if (!StringUtils.isNotBlank((CharSequence)bucketName) || !StringUtils.isNotBlank((CharSequence)fileName)) {
            log.error("[Herodotus] |- Argument bucketName or fileName is blank in removeFile.");
            throw new IllegalArgumentException("Argument is illegal.");
        }
        this.minioTemplate.removeObject(bucketName, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinioObject uploadShareLink(String shareLink) throws Exception {
        InputStream urlInputStream = null;
        InputStream resultStream = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(shareLink).openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
            urlInputStream = conn.getInputStream();
            String fileSuffix = contentTypeMap.get(conn.getContentType());
            byte[] getData = MinioManager.readInputStream(urlInputStream);
            resultStream = new ByteArrayInputStream(getData);
            MinioObject minioObject = this.uploadFile(resultStream, IdUtil.fastUUID() + fileSuffix);
            return minioObject;
        }
        finally {
            if (null != resultStream) {
                resultStream.close();
            }
            if (null != urlInputStream) {
                urlInputStream.close();
            }
        }
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    static {
        contentTypeMap.put("audio/aac", ".aac");
        contentTypeMap.put("application/x-abiword", ".abw");
        contentTypeMap.put("application/x-freearc", ".arc");
        contentTypeMap.put("video/x-msvideo", ".avi");
        contentTypeMap.put("application/vnd.amazon.ebook", ".azw");
        contentTypeMap.put("application/octet-stream", ".bin");
        contentTypeMap.put("image/bmp", ".bmp");
        contentTypeMap.put("application/x-bzip", ".bz");
        contentTypeMap.put("application/x-bzip2", ".bz2");
        contentTypeMap.put("application/x-csh", ".csh");
        contentTypeMap.put("text/css", ".css");
        contentTypeMap.put("text/csv", ".csv");
        contentTypeMap.put("application/msword", ".doc");
        contentTypeMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", ".docx");
        contentTypeMap.put("application/vnd.ms-fontobject", ".eot");
        contentTypeMap.put("application/epub+zip", ".epub");
        contentTypeMap.put("image/gif", ".gif");
        contentTypeMap.put("text/html", ".htm");
        contentTypeMap.put("image/vnd.microsoft.icon", ".ico");
        contentTypeMap.put("text/calendar", ".ics");
        contentTypeMap.put("application/java-archive", ".jar");
        contentTypeMap.put("image/jpeg", ".jpeg");
        contentTypeMap.put("text/javascript", ".js");
        contentTypeMap.put("application/json", ".json");
        contentTypeMap.put("application/ld+json", ".jsonld");
        contentTypeMap.put("audio/midi", ".mid");
        contentTypeMap.put("audio/x-midi", ".mid");
        contentTypeMap.put("audio/mpeg", ".mp3");
        contentTypeMap.put("video/mpeg", ".mpeg");
        contentTypeMap.put("application/vnd.apple.installer+xml", ".mpkg");
        contentTypeMap.put("application/vnd.oasis.opendocument.presentation", ".odp");
        contentTypeMap.put("application/vnd.oasis.opendocument.spreadsheet", ".ods");
        contentTypeMap.put("application/vnd.oasis.opendocument.text", ".odt");
        contentTypeMap.put("audio/ogg", ".oga");
        contentTypeMap.put("video/ogg", ".ogv");
        contentTypeMap.put("application/ogg", ".ogx");
        contentTypeMap.put("font/otf", ".otf");
        contentTypeMap.put("image/png", ".png");
        contentTypeMap.put("application/pdf", ".pdf");
        contentTypeMap.put("application/vnd.ms-powerpoint", ".ppt");
        contentTypeMap.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", ".pptx");
        contentTypeMap.put("application/x-rar-compressed", ".rar");
        contentTypeMap.put("application/rtf", ".rtf");
        contentTypeMap.put("application/x-sh", ".sh");
        contentTypeMap.put("image/svg+xml", ".svg");
        contentTypeMap.put("application/x-shockwave-flash", ".swf");
        contentTypeMap.put("application/x-tar", ".tar");
        contentTypeMap.put("image/tiff", "tiff");
        contentTypeMap.put("font/ttf", ".ttf");
        contentTypeMap.put("text/plain", ".txt");
        contentTypeMap.put("application/vnd.visio", ".vsd");
        contentTypeMap.put("audio/wav", ".wav");
        contentTypeMap.put("audio/webm", ".weba");
        contentTypeMap.put("video/webm", ".webm");
        contentTypeMap.put("image/webp", ".webp");
        contentTypeMap.put("font/woff", ".woff");
        contentTypeMap.put("font/woff2", ".woff2");
        contentTypeMap.put("application/xhtml+xml", ".xhtml");
        contentTypeMap.put("application/vnd.ms-excel", ".xls");
        contentTypeMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ".xlsx");
        contentTypeMap.put("application/xml", ".xml");
        contentTypeMap.put("text/xml", ".xml");
        contentTypeMap.put("application/vnd.mozilla.xul+xml", ".xul");
        contentTypeMap.put("application/zip", ".zip");
        contentTypeMap.put("video/3gpp", ".3gp");
        contentTypeMap.put("audio/3gpp", ".3gp");
        contentTypeMap.put("video/3gpp2", ".3g2");
        contentTypeMap.put("audio/3gpp2", ".3g2");
        contentTypeMap.put("application/x-7z-compressed", ".7z");
    }
}

