/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.core;

import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import io.minio.MinioClient;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class MinioClientPool {
    private final GenericObjectPool<MinioClient> minioClientPool;

    public MinioClientPool(MinioProperties minioProperties) {
        MinioClientPoolFactory factory = new MinioClientPoolFactory(minioProperties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(minioProperties.getPool().getMaxTotal());
        config.setMaxIdle(minioProperties.getPool().getMaxIdle());
        config.setMinIdle(minioProperties.getPool().getMinIdle());
        config.setMaxWaitMillis(minioProperties.getPool().getMaxWait().toMillis());
        config.setBlockWhenExhausted(minioProperties.getPool().isBlockWhenExhausted());
        this.minioClientPool = new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    public GenericObjectPool<MinioClient> getMinioClientPool() {
        return this.minioClientPool;
    }

    public static class MinioClientPoolFactory
    extends BasePooledObjectFactory<MinioClient> {
        private final MinioProperties minioProperties;

        public MinioClientPoolFactory(MinioProperties minioProperties) {
            this.minioProperties = minioProperties;
        }

        public MinioClient create() throws Exception {
            return MinioClient.builder().endpoint(this.minioProperties.getEndpoint()).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).build();
        }

        public PooledObject<MinioClient> makeObject() throws Exception {
            return super.makeObject();
        }

        public PooledObject<MinioClient> wrap(MinioClient minioClient) {
            return new DefaultPooledObject((Object)minioClient);
        }
    }
}

