/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.oss.minio.core.MinioTemplate;
import cn.herodotus.engine.oss.minio.domain.MinioItem;
import cn.herodotus.engine.oss.minio.domain.MinioObject;
import cn.herodotus.engine.oss.minio.domain.ObjectInfo;
import io.minio.messages.Bucket;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/oss/minio"})
@Tags(value={@Tag(name="Minio \u5bf9\u8c61\u5b58\u50a8\u63a5\u53e3"), @Tag(name="\u5bf9\u8c61\u5b58\u50a8\u63a5\u53e3"), @Tag(name="\u5916\u90e8\u5e94\u7528\u96c6\u6210\u63a5\u53e3")})
public class MinioController {
    @Autowired
    private MinioTemplate minioTemplate;

    @Operation(summary="\u521b\u5efaBucket", description="\u521b\u5efaBucket", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="Bucket\u8be6\u60c5", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="userId")})
    @PostMapping(value={"/bucket/{bucketName}"})
    public Result<Bucket> createBucker(@PathVariable String bucketName) {
        this.minioTemplate.createBucket(bucketName);
        Bucket bucket = this.minioTemplate.getBucket(bucketName).get();
        if (ObjectUtils.isNotEmpty((Object)bucket)) {
            return Result.success((String)"\u521b\u5efa\u6210\u529f!", (Object)bucket);
        }
        return Result.failure((String)"\u521b\u5efa\u5931\u8d25\uff01");
    }

    @Operation(summary="\u83b7\u53d6\u5168\u90e8Bucket", description="\u83b7\u53d6\u5168\u90e8Bucket", responses={@ApiResponse(description="Bucket\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))})})
    @GetMapping(value={"/bucket"})
    public Result<List<Bucket>> getBuckets() {
        List<Bucket> buckets = this.minioTemplate.getAllBuckets();
        if (ObjectUtils.isNotEmpty(buckets)) {
            if (CollectionUtils.isNotEmpty(buckets)) {
                return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", buckets);
            }
            return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        }
        return Result.failure((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
    }

    @Operation(summary="\u5220\u9664Bucket", description="\u6839\u636e\u540d\u79f0\u83b7\u53d6bucket", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0")})
    @GetMapping(value={"/bucket/{bucketName}"})
    public Result<Bucket> getBucket(@PathVariable String bucketName) {
        Bucket bucket = this.minioTemplate.getBucket(bucketName).get();
        if (ObjectUtils.isNotEmpty((Object)bucket)) {
            return Result.success((String)"\u521b\u5efa\u6210\u529f!", (Object)bucket);
        }
        return Result.failure((String)"\u521b\u5efa\u5931\u8d25\uff01");
    }

    @Operation(summary="\u5220\u9664Bucket", description="\u5220\u9664bucket", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0")})
    @DeleteMapping(value={"/bucket/{bucketName}"})
    public Result<String> deleteBucket(@PathVariable String bucketName) {
        this.minioTemplate.removeBucket(bucketName);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20", description="\u5b58\u5165\u5bf9\u8c61\u5230bucket\u5e76\u8bbe\u7f6e\u5bf9\u8c61\u540d\u79f0", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="multipartFile", required=true, description="multipartFile\u5bf9\u8c61", schema=@Schema(implementation=MultipartFile.class)), @Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0")})
    @PostMapping(value={"/object/{bucketName}"})
    public Result<MinioObject> putObject(@RequestBody MultipartFile multipartFile, @PathVariable String bucketName) {
        String name = multipartFile.getOriginalFilename();
        return this.putObject(multipartFile, bucketName, name);
    }

    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20", description="\u5b58\u5165\u5bf9\u8c61\u5230bucket\u5e76\u8bbe\u7f6e\u5bf9\u8c61\u540d\u79f0", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="multipartFile", required=true, description="multipartFile\u5bf9\u8c61", schema=@Schema(implementation=MultipartFile.class)), @Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0"), @Parameter(name="objectName", required=true, in=ParameterIn.PATH, description="\u5bf9\u8c61\u540d\u79f0")})
    @PostMapping(value={"/object/{bucketName}/{objectName}"})
    public Result<MinioObject> putObject(@RequestBody MultipartFile multipartFile, @PathVariable String bucketName, @PathVariable String objectName) {
        try {
            this.minioTemplate.putObject(bucketName, objectName, multipartFile.getInputStream(), multipartFile.getSize(), multipartFile.getContentType());
            MinioObject minioObject = new MinioObject(this.minioTemplate.getObjectInfo(bucketName, objectName));
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)minioObject);
        }
        catch (IOException e) {
            return Result.failure((String)"\u4e0a\u4f20\u5931\u8d25\uff0cMultipartFile IO \u9519\u8bef\uff01");
        }
    }

    @Operation(summary="\u83b7\u53d6\u5bf9\u8c61", description="\u6839\u636ebucket\u540d\u79f0\u548c\u5bf9\u8c61\u540d\u79f0\u8fc7\u6ee4\u6240\u6709\u5bf9\u8c61", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=List.class))})})
    @Parameters(value={@Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0"), @Parameter(name="objectName", required=true, in=ParameterIn.PATH, description="\u5bf9\u8c61\u540d\u79f0")})
    @GetMapping(value={"/object/{bucketName}/{objectName}"})
    public Result<List<MinioItem>> filterObject(@PathVariable String bucketName, @PathVariable String objectName) {
        List<MinioItem> minioItems = this.minioTemplate.getAllObjectsByPrefix(bucketName, objectName, true);
        if (ObjectUtils.isNotEmpty(minioItems)) {
            if (CollectionUtils.isNotEmpty(minioItems)) {
                return Result.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", minioItems);
            }
            return Result.empty((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        }
        return Result.failure((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
    }

    @Operation(summary="\u83b7\u53d6\u5bf9\u8c61", description="\u6839\u636e\u540d\u79f0\u83b7\u53d6bucket\u4e0b\u7684\u5bf9\u8c61\u5e76\u8bbe\u7f6e\u5916\u94fe\u7684\u8fc7\u671f\u65f6\u95f4", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectInfo.class))})})
    @Parameters(value={@Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0"), @Parameter(name="objectName", required=true, in=ParameterIn.PATH, description="\u5bf9\u8c61\u540d\u79f0"), @Parameter(name="expires", required=true, in=ParameterIn.PATH, description="\u8fc7\u671f\u65f6\u95f4\uff0cDuration\u8868\u8fbe\u5f0f")})
    @GetMapping(value={"/object/{bucketName}/{objectName}/{expires}"})
    public Result<ObjectInfo> getObject(@PathVariable String bucketName, @PathVariable String objectName, @PathVariable String expires) throws Exception {
        Duration expireDuration = Duration.parse(expires);
        if (expireDuration != Duration.ZERO) {
            String url = this.minioTemplate.getObjectURL(bucketName, objectName, expireDuration);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                ObjectInfo objectInfo = new ObjectInfo();
                objectInfo.setObjectName(objectName);
                objectInfo.setBucketName(bucketName);
                objectInfo.setUrl(url);
                objectInfo.setExpires(expireDuration.toString());
                return Result.success((String)"\u83b7\u53d6\u6210\u529f\uff01", (Object)objectInfo);
            }
            return Result.failure((String)"\u83b7\u53d6\u5931\u8d25\uff01");
        }
        return Result.failure((String)"Expires \u53c2\u6570\u683c\u5f0f\u9519\u8bef!");
    }

    @Operation(summary="\u5220\u9664\u5bf9\u8c61", description="\u6839\u636eBucket\u540d\u5b57\u548c\u5bf9\u8c61\u540d\u79f0\u5220\u9664\u5bf9\u8c61", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="bucketName", required=true, in=ParameterIn.PATH, description="Bucket\u540d\u79f0"), @Parameter(name="objectName", required=true, in=ParameterIn.PATH, description="\u5bf9\u8c61\u540d\u79f0")})
    @DeleteMapping(value={"/object/{bucketName}/{objectName}/"})
    public Result<String> deleteObject(@PathVariable String bucketName, @PathVariable String objectName) {
        this.minioTemplate.removeObject(bucketName, objectName);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }
}

