/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oss.minio.configuration;

import cn.herodotus.engine.oss.minio.annotation.ConditionalOnMinioEnabled;
import cn.herodotus.engine.oss.minio.core.MinioClientPool;
import cn.herodotus.engine.oss.minio.core.MinioManager;
import cn.herodotus.engine.oss.minio.core.MinioTemplate;
import cn.herodotus.engine.oss.minio.properties.MinioProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMinioEnabled
@EnableConfigurationProperties(value={MinioProperties.class})
public class MinioConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MinioConfiguration.class);

    @PostConstruct
    public void init() {
        log.debug("[Herodotus] |- SDK [Engine Oss Minio] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioClientPool minioClientPool(MinioProperties minioProperties) {
        MinioClientPool minioClientPool = new MinioClientPool(minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Client Pool] Auto Configure.");
        return minioClientPool;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MinioClientPool.class})
    public MinioTemplate minioTemplate(MinioClientPool minioClientPool) {
        MinioTemplate minioTemplate = new MinioTemplate(minioClientPool);
        log.trace("[Herodotus] |- Bean [Minio Template] Auto Configure.");
        return minioTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MinioTemplate.class})
    public MinioManager minioManager(MinioTemplate minioTemplate, MinioProperties minioProperties) {
        MinioManager minioManager = new MinioManager(minioTemplate, minioProperties);
        log.trace("[Herodotus] |- Bean [Minio Manager] Auto Configure.");
        return minioManager;
    }
}

