/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.response;

import cn.herodotus.engine.oauth2.management.service.OAuth2DeviceService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceVerificationAuthenticationToken;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class OAuth2DeviceVerificationResponseHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuth2DeviceVerificationResponseHandler.class);
    private final OAuth2DeviceService deviceService;

    public OAuth2DeviceVerificationResponseHandler(OAuth2DeviceService deviceService) {
        super("/device_activated");
        this.deviceService = deviceService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        OAuth2DeviceVerificationAuthenticationToken deviceVerificationAuthenticationToken = (OAuth2DeviceVerificationAuthenticationToken)authentication;
        log.info("[Herodotus] |- Device verification authentication token is : [{}]", (Object)deviceVerificationAuthenticationToken);
        String clientId = deviceVerificationAuthenticationToken.getClientId();
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            boolean success = this.deviceService.activate(clientId, true);
            log.info("[Herodotus] |- The activation status of the device is : [{}]", (Object)success);
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }
}

