/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.definition.domain.Result;
import cn.herodotus.engine.data.core.service.WriteableService;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Compliance;
import cn.herodotus.engine.oauth2.management.service.OAuth2ComplianceService;
import cn.herodotus.engine.rest.core.controller.BaseWriteableRestController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/compliance"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u5e94\u7528\u5b89\u5168\u5408\u89c4\u63a5\u53e3"), @Tag(name="OAuth2 \u5ba1\u8ba1\u7ba1\u7406\u63a5\u53e3")})
public class OAuth2ComplianceController
extends BaseWriteableRestController<OAuth2Compliance, String> {
    private final OAuth2ComplianceService complianceService;

    @Autowired
    public OAuth2ComplianceController(OAuth2ComplianceService complianceService) {
        this.complianceService = complianceService;
    }

    public WriteableService<OAuth2Compliance, String> getWriteableService() {
        return this.complianceService;
    }

    @Operation(summary="\u6a21\u7cca\u6761\u4ef6\u67e5\u8be2\u5408\u89c4\u4fe1\u606f", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u6a21\u7cca\u67e5\u8be2\u5408\u89c4\u4fe1\u606f", responses={@ApiResponse(description="\u4eba\u5458\u5206\u9875\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="principalName", description="\u7528\u6237\u8d26\u53f7"), @Parameter(name="clientId", description="\u5ba2\u6237\u7aefID"), @Parameter(name="ip", description="IP\u5730\u5740")})
    @GetMapping(value={"/condition"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="principalName", required=false) String principalName, @RequestParam(value="clientId", required=false) String clientId, @RequestParam(value="ip", required=false) String ip) {
        Page<OAuth2Compliance> pages = this.complianceService.findByCondition(pageNumber, pageSize, principalName, clientId, ip);
        return this.result(pages);
    }
}

