/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.core.enums.Protocol;
import cn.herodotus.engine.assistant.core.utils.http.SessionUtils;
import cn.herodotus.engine.assistant.definition.domain.oauth2.SecretKey;
import cn.herodotus.engine.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import cn.hutool.v7.core.codec.binary.Base64;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.http.ResponseCookie;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;

@Controller
public class LoginController {
    private final OAuth2AuthenticationProperties authenticationProperties;
    private final SessionProperties sessionProperties;
    private final HttpCryptoProcessor httpCryptoProcessor;

    public LoginController(OAuth2AuthenticationProperties authenticationProperties, SessionProperties sessionProperties, HttpCryptoProcessor httpCryptoProcessor) {
        this.authenticationProperties = authenticationProperties;
        this.sessionProperties = sessionProperties;
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public ModelAndView login(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView("login");
        boolean loginError = this.isErrorPage(request);
        boolean logoutSuccess = this.isLogoutSuccess(request);
        String errorMessage = this.getErrorMessage(request);
        modelAndView.addObject("vulgar_tycoon", (Object)this.getFormLogin().getUsernameParameter());
        modelAndView.addObject("beast", (Object)this.getFormLogin().getPasswordParameter());
        modelAndView.addObject("anubis", (Object)this.getFormLogin().getRememberMeParameter());
        modelAndView.addObject("graphic", (Object)this.getFormLogin().getCaptchaParameter());
        modelAndView.addObject("show_verification_code", (Object)this.getFormLogin().getCaptchaEnabled());
        modelAndView.addObject("forgot_password_url", (Object)this.getFormLogin().getForgotPasswordUrl());
        modelAndView.addObject("registration_ur", (Object)this.getFormLogin().getRegistrationUrl());
        modelAndView.addObject("show_registration_url", (Object)this.getFormLogin().isRegistrationEnabled());
        modelAndView.addObject("show_forgot_password_url", (Object)this.getFormLogin().isForgotPasswordEnabled());
        modelAndView.addObject("verification_category", (Object)this.getFormLogin().getCategory());
        modelAndView.addObject("login_error", (Object)loginError);
        modelAndView.addObject("logout_success", (Object)logoutSuccess);
        modelAndView.addObject("message", (Object)(StringUtils.isNotBlank((CharSequence)errorMessage) ? HtmlUtils.htmlEscape((String)errorMessage) : null));
        modelAndView.addObject("contextPath", (Object)request.getContextPath());
        this.processSecretKey(modelAndView, request, response);
        return modelAndView;
    }

    public void processSecretKey(ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        SecretKey secretKey;
        String sessionId = SessionUtils.analyseSessionId((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            secretKey = this.httpCryptoProcessor.createSecretKey(null, this.sessionProperties.getTimeout());
            sessionId = secretKey.getIdentity();
            ResponseCookie cookie = ResponseCookie.from((String)"SESSION", (String)Base64.encode((CharSequence)secretKey.getIdentity())).path(request.getContextPath() + "/").httpOnly(true).secure(Strings.CI.equals(Protocol.HTTPS.getPrefix(), request.getScheme())).sameSite("Lax").maxAge(this.authenticationProperties.getFormLogin().getCookieMaxAge()).build();
            response.setHeader("Set-Cookie", cookie.toString());
        } else {
            secretKey = this.httpCryptoProcessor.createSecretKey(sessionId, this.sessionProperties.getTimeout());
            sessionId = secretKey.getIdentity();
        }
        modelAndView.addObject("soup_spoon", (Object)secretKey.getPublicKey());
        modelAndView.addObject("sessionId", (Object)sessionId);
    }

    private OAuth2AuthenticationProperties.FormLogin getFormLogin() {
        return this.authenticationProperties.getFormLogin();
    }

    private boolean isLogoutSuccess(HttpServletRequest request) {
        String logoutSuccessUrl = this.getFormLogin().getLogoutSuccessUrl();
        return StringUtils.isNotBlank((CharSequence)logoutSuccessUrl) && this.matches(request, logoutSuccessUrl);
    }

    private boolean isErrorPage(HttpServletRequest request) {
        return this.matches(request, this.getFormLogin().getFailureUrl());
    }

    private String getErrorMessage(HttpServletRequest request) {
        String message;
        HttpSession session = SessionUtils.getSession((HttpServletRequest)request);
        if (ObjectUtils.isNotEmpty((Object)session) && ObjectUtils.isNotEmpty((Object)(message = (String)session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION")))) {
            return message;
        }
        return null;
    }

    private boolean matches(HttpServletRequest request, String url) {
        if (!"GET".equals(request.getMethod()) || url == null) {
            return false;
        }
        Object uri = request.getRequestURI();
        int pathParamIndex = ((String)uri).indexOf(59);
        if (pathParamIndex > 0) {
            uri = ((String)uri).substring(0, pathParamIndex);
        }
        if (request.getQueryString() != null) {
            uri = (String)uri + "?" + request.getQueryString();
        }
        if ("".equals(request.getContextPath())) {
            return ((String)uri).equals(url);
        }
        return ((String)uri).equals(request.getContextPath() + url);
    }
}

