/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.compliance.listener;

import cn.herodotus.engine.assistant.definition.domain.oauth2.PrincipalDetails;
import cn.herodotus.engine.oauth2.authentication.stamp.SignInFailureLimitedStampManager;
import cn.herodotus.engine.oauth2.management.service.OAuth2ComplianceService;
import cn.hutool.v7.crypto.SecureUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthenticationSuccessListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationSuccessListener.class);
    private final SignInFailureLimitedStampManager stampManager;
    private final OAuth2ComplianceService complianceService;

    public AuthenticationSuccessListener(SignInFailureLimitedStampManager stampManager, OAuth2ComplianceService complianceService) {
        this.stampManager = stampManager;
        this.complianceService = complianceService;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        if (authentication instanceof OAuth2AccessTokenAuthenticationToken) {
            OAuth2AccessTokenAuthenticationToken authenticationToken = (OAuth2AccessTokenAuthenticationToken)authentication;
            Object details = authentication.getDetails();
            String username = null;
            if (ObjectUtils.isNotEmpty((Object)details) && details instanceof PrincipalDetails) {
                PrincipalDetails user = (PrincipalDetails)details;
                username = user.getUsername();
            }
            String clientId = authenticationToken.getRegisteredClient().getId();
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (ObjectUtils.isNotEmpty((Object)requestAttributes) && requestAttributes instanceof ServletRequestAttributes) {
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
                HttpServletRequest request = servletRequestAttributes.getRequest();
                if (ObjectUtils.isNotEmpty((Object)request) && StringUtils.isNotBlank((CharSequence)username)) {
                    this.complianceService.save(username, clientId, "\u7528\u6237\u767b\u5f55", request);
                    String key = SecureUtil.md5((String)username);
                    boolean hasKey = this.stampManager.containKey((Object)key);
                    if (hasKey) {
                        this.stampManager.delete((Object)key);
                    }
                }
            } else {
                log.warn("[Herodotus] |- Can not get request and user name, skip!");
            }
        }
    }
}

