/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.compliance.listener;

import cn.herodotus.engine.oauth2.management.compliance.OAuth2AccountStatusManager;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class AccountAutoEnableListener
extends KeyExpirationEventMessageListener {
    private static final Logger log = LoggerFactory.getLogger(AccountAutoEnableListener.class);
    private final OAuth2AccountStatusManager accountStatusManager;

    public AccountAutoEnableListener(RedisMessageListenerContainer listenerContainer, OAuth2AccountStatusManager accountStatusManager) {
        super(listenerContainer);
        this.accountStatusManager = accountStatusManager;
    }

    public void onMessage(Message message, byte[] pattern) {
        String key = new String(message.getBody(), StandardCharsets.UTF_8);
        if (Strings.CS.contains((CharSequence)key, (CharSequence)"cache:token:locked:user_details:")) {
            String userId = StringUtils.substringAfterLast((String)key, (String)":");
            log.info("[Herodotus] |- Parse the user [{}] at expired redis cache key [{}]", (Object)userId, (Object)key);
            if (StringUtils.isNotBlank((CharSequence)userId)) {
                log.debug("[Herodotus] |- Automatically unlock user account [{}]", (Object)userId);
                this.accountStatusManager.enable(userId);
            }
        }
    }
}

