/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.definition.domain.Result;
import cn.herodotus.engine.message.core.logic.event.AccountReleaseFromCacheEvent;
import cn.herodotus.engine.oauth2.management.service.OAuth2ComplianceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotBlank;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oauth2"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u6269\u5c55\u63a5\u53e3")})
public class OAuthSignOutController {
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2ComplianceService complianceService;
    private final ApplicationContext applicationContext;

    public OAuthSignOutController(OAuth2AuthorizationService authorizationService, OAuth2ComplianceService complianceService, ApplicationContext applicationContext) {
        this.authorizationService = authorizationService;
        this.complianceService = complianceService;
        this.applicationContext = applicationContext;
    }

    @Operation(summary="\u6ce8\u9500OAuth2\u5e94\u7528", description="\u6839\u636e\u63a5\u6536\u5230\u7684AccessToken,\u5220\u9664\u540e\u7aef\u5b58\u50a8\u7684Token\u4fe1\u606f,\u8d77\u5230\u6ce8\u9500\u6548\u679c", requestBody=@RequestBody(content={@Content(mediaType="application/x-www-form-urlencoded")}), responses={@ApiResponse(description="\u662f\u5426\u6210\u529f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="accessToken", required=true, description="Access Token"), @Parameter(name="Authorization", in=ParameterIn.HEADER, required=true, description="Basic Token")})
    @PutMapping(value={"/sign-out"})
    public Result<String> signOut(@RequestParam(name="accessToken") @NotBlank String accessToken, HttpServletRequest request) {
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessToken, OAuth2TokenType.ACCESS_TOKEN);
        if (ObjectUtils.isNotEmpty((Object)authorization)) {
            this.authorizationService.remove(authorization);
            this.complianceService.save(authorization.getPrincipalName(), authorization.getRegisteredClientId(), "\u9000\u51fa\u7cfb\u7edf", request);
            this.applicationContext.publishEvent((ApplicationEvent)new AccountReleaseFromCacheEvent(authorization.getPrincipalName()));
        }
        return Result.success((String)"\u6ce8\u9500\u6210\u529f");
    }
}

